/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.util;

import hive.org.eigenbase.util.property.BooleanProperty;
import hive.org.eigenbase.util.property.StringProperty;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Properties;

public class SaffronProperties
extends Properties {
    private static SaffronProperties properties;
    public final BooleanProperty allowInfiniteCostConverters = new BooleanProperty((Properties)this, "saffron.opt.allowInfiniteCostConverters", true);
    public final StringProperty defaultCharset = new StringProperty((Properties)this, "saffron.default.charset", "ISO-8859-1");
    public final StringProperty defaultNationalCharset = new StringProperty((Properties)this, "saffron.default.nationalcharset", "ISO-8859-1");
    public final StringProperty defaultCollation = new StringProperty((Properties)this, "saffron.default.collation.name", "ISO-8859-1$en_US");
    public final StringProperty defaultCollationStrength = new StringProperty((Properties)this, "saffron.default.collation.strength", "primary");

    private SaffronProperties() {
    }

    public static SaffronProperties instance() {
        if (properties == null) {
            properties = new SaffronProperties();
            try (InputStream stream = SaffronProperties.class.getClassLoader().getResourceAsStream("saffron.properties");){
                if (stream != null) {
                    properties.load(stream);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("while reading from saffron.properties file", e);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            properties.loadSaffronProperties(System.getProperties());
        }
        return properties;
    }

    public void loadSaffronProperties(Properties source) {
        Enumeration<Object> keys = source.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = source.getProperty(key);
            if (!key.startsWith("saffron.") && !key.startsWith("net.sf.saffron.")) continue;
            properties.setProperty(key, value);
        }
    }

    public boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, false);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("1") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    public int getIntProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            return -1;
        }
        int i = Integer.valueOf(value);
        return i;
    }
}

