/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.tools;

import hive.com.google.common.base.Function;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.ImmutableSet;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRules;
import hive.org.apache.calcite.interpreter.NoneToBindableConverterRule;
import hive.org.apache.calcite.plan.RelOptCostImpl;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.plan.hep.HepMatchOrder;
import hive.org.apache.calcite.plan.hep.HepPlanner;
import hive.org.apache.calcite.plan.hep.HepProgram;
import hive.org.apache.calcite.plan.hep.HepProgramBuilder;
import hive.org.apache.calcite.prepare.CalcitePrepareImpl;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import hive.org.apache.calcite.rel.rules.AggregateReduceFunctionsRule;
import hive.org.apache.calcite.rel.rules.AggregateStarTableRule;
import hive.org.apache.calcite.rel.rules.CalcMergeRule;
import hive.org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import hive.org.apache.calcite.rel.rules.FilterCalcMergeRule;
import hive.org.apache.calcite.rel.rules.FilterJoinRule;
import hive.org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import hive.org.apache.calcite.rel.rules.FilterTableScanRule;
import hive.org.apache.calcite.rel.rules.FilterToCalcRule;
import hive.org.apache.calcite.rel.rules.JoinAssociateRule;
import hive.org.apache.calcite.rel.rules.JoinCommuteRule;
import hive.org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import hive.org.apache.calcite.rel.rules.JoinToMultiJoinRule;
import hive.org.apache.calcite.rel.rules.LoptOptimizeJoinRule;
import hive.org.apache.calcite.rel.rules.MultiJoinOptimizeBushyRule;
import hive.org.apache.calcite.rel.rules.ProjectCalcMergeRule;
import hive.org.apache.calcite.rel.rules.ProjectMergeRule;
import hive.org.apache.calcite.rel.rules.ProjectToCalcRule;
import hive.org.apache.calcite.rel.rules.SemiJoinRule;
import hive.org.apache.calcite.rel.rules.SortProjectTransposeRule;
import hive.org.apache.calcite.rel.rules.TableScanRule;
import hive.org.apache.calcite.tools.Program;
import hive.org.apache.calcite.tools.RuleSet;
import hive.org.apache.calcite.tools.RuleSets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Programs {
    private static final Function<RuleSet, Program> RULE_SET_TO_PROGRAM = new Function<RuleSet, Program>(){

        @Override
        public Program apply(RuleSet ruleSet) {
            return Programs.of(ruleSet);
        }
    };
    public static final ImmutableList<RelOptRule> CALC_RULES = ImmutableList.of(NoneToBindableConverterRule.INSTANCE, EnumerableRules.ENUMERABLE_CALC_RULE, EnumerableRules.ENUMERABLE_FILTER_TO_CALC_RULE, EnumerableRules.ENUMERABLE_PROJECT_TO_CALC_RULE, CalcMergeRule.INSTANCE, FilterCalcMergeRule.INSTANCE, ProjectCalcMergeRule.INSTANCE, FilterToCalcRule.INSTANCE, ProjectToCalcRule.INSTANCE, CalcMergeRule.INSTANCE, FilterCalcMergeRule.INSTANCE, ProjectCalcMergeRule.INSTANCE, new RelOptRule[0]);
    public static final Program CALC_PROGRAM = Programs.hep(CALC_RULES, true, DefaultRelMetadataProvider.INSTANCE);
    public static final ImmutableSet<RelOptRule> RULE_SET = ImmutableSet.of(EnumerableRules.ENUMERABLE_JOIN_RULE, EnumerableRules.ENUMERABLE_MERGE_JOIN_RULE, EnumerableRules.ENUMERABLE_SEMI_JOIN_RULE, EnumerableRules.ENUMERABLE_CORRELATE_RULE, EnumerableRules.ENUMERABLE_PROJECT_RULE, EnumerableRules.ENUMERABLE_FILTER_RULE, new RelOptRule[]{EnumerableRules.ENUMERABLE_AGGREGATE_RULE, EnumerableRules.ENUMERABLE_SORT_RULE, EnumerableRules.ENUMERABLE_LIMIT_RULE, EnumerableRules.ENUMERABLE_UNION_RULE, EnumerableRules.ENUMERABLE_INTERSECT_RULE, EnumerableRules.ENUMERABLE_MINUS_RULE, EnumerableRules.ENUMERABLE_TABLE_MODIFICATION_RULE, EnumerableRules.ENUMERABLE_VALUES_RULE, EnumerableRules.ENUMERABLE_WINDOW_RULE, SemiJoinRule.INSTANCE, TableScanRule.INSTANCE, CalcitePrepareImpl.COMMUTE ? JoinAssociateRule.INSTANCE : ProjectMergeRule.INSTANCE, AggregateStarTableRule.INSTANCE, AggregateStarTableRule.INSTANCE2, FilterTableScanRule.INSTANCE, FilterProjectTransposeRule.INSTANCE, FilterJoinRule.FILTER_ON_JOIN, AggregateExpandDistinctAggregatesRule.INSTANCE, AggregateReduceFunctionsRule.INSTANCE, FilterAggregateTransposeRule.INSTANCE, JoinCommuteRule.INSTANCE, JoinPushThroughJoinRule.RIGHT, JoinPushThroughJoinRule.LEFT, SortProjectTransposeRule.INSTANCE});

    private Programs() {
    }

    public static Program of(RuleSet ruleSet) {
        return new RuleSetProgram(ruleSet);
    }

    public static List<Program> listOf(RuleSet ... ruleSets) {
        return Lists.transform(Arrays.asList(ruleSets), RULE_SET_TO_PROGRAM);
    }

    public static List<Program> listOf(List<RuleSet> ruleSets) {
        return Lists.transform(ruleSets, RULE_SET_TO_PROGRAM);
    }

    public static Program ofRules(RelOptRule ... rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program ofRules(Collection<RelOptRule> rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program sequence(Program ... programs) {
        return new SequenceProgram(ImmutableList.copyOf(programs));
    }

    public static Program hep(ImmutableList<RelOptRule> rules, boolean noDag, RelMetadataProvider metadataProvider) {
        HepProgramBuilder builder = HepProgram.builder();
        for (RelOptRule rule : rules) {
            builder.addRuleInstance(rule);
        }
        return Programs.of(builder.build(), noDag, metadataProvider);
    }

    public static Program of(final HepProgram hepProgram, final boolean noDag, final RelMetadataProvider metadataProvider) {
        return new Program(){

            @Override
            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                HepPlanner hepPlanner = new HepPlanner(hepProgram, null, noDag, null, RelOptCostImpl.FACTORY);
                ArrayList<RelMetadataProvider> list = Lists.newArrayList();
                if (metadataProvider != null) {
                    list.add(metadataProvider);
                }
                hepPlanner.registerMetadataProviders(list);
                RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of(list);
                rel.getCluster().setMetadataProvider(plannerChain);
                hepPlanner.setRoot(rel);
                return hepPlanner.findBestExp();
            }
        };
    }

    public static Program heuristicJoinOrder(final Collection<RelOptRule> rules, final boolean bushy, final int minJoinCount) {
        return new Program(){

            @Override
            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                Program program;
                int joinCount = RelOptUtil.countJoins(rel);
                if (joinCount < minJoinCount) {
                    program = Programs.ofRules(rules);
                } else {
                    HepProgram hep = new HepProgramBuilder().addRuleInstance(FilterJoinRule.FILTER_ON_JOIN).addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance(JoinToMultiJoinRule.INSTANCE).build();
                    Program program1 = Programs.of(hep, false, DefaultRelMetadataProvider.INSTANCE);
                    ArrayList<RelOptRule> list = Lists.newArrayList(rules);
                    list.removeAll(ImmutableList.of(JoinCommuteRule.INSTANCE, JoinAssociateRule.INSTANCE, JoinPushThroughJoinRule.LEFT, JoinPushThroughJoinRule.RIGHT));
                    list.add(bushy ? MultiJoinOptimizeBushyRule.INSTANCE : LoptOptimizeJoinRule.INSTANCE);
                    Program program2 = Programs.ofRules(list);
                    program = Programs.sequence(program1, program2);
                }
                return program.run(planner, rel, requiredOutputTraits);
            }
        };
    }

    public static Program getProgram() {
        return new Program(){

            @Override
            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                return null;
            }
        };
    }

    public static Program standard() {
        return Programs.standard(DefaultRelMetadataProvider.INSTANCE);
    }

    public static Program standard(RelMetadataProvider metadataProvider) {
        Program program1 = new Program(){

            @Override
            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                RelNode rootRel2;
                RelNode relNode = rootRel2 = rel.getTraitSet().equals(requiredOutputTraits) ? rel : planner.changeTraits(rel, requiredOutputTraits);
                assert (rootRel2 != null);
                planner.setRoot(rootRel2);
                RelOptPlanner planner2 = planner.chooseDelegate();
                RelNode rootRel3 = planner2.findBestExp();
                assert (rootRel3 != null) : "could not implement exp";
                return rootRel3;
            }
        };
        Program program2 = CALC_PROGRAM;
        return Programs.sequence(program1, program2);
    }

    private static class SequenceProgram
    implements Program {
        private final ImmutableList<Program> programs;

        SequenceProgram(ImmutableList<Program> programs) {
            this.programs = programs;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
            for (Program program : this.programs) {
                rel = program.run(planner, rel, requiredOutputTraits);
            }
            return rel;
        }
    }

    static class RuleSetProgram
    implements Program {
        final RuleSet ruleSet;

        private RuleSetProgram(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
            planner.clear();
            for (RelOptRule rule : this.ruleSet) {
                planner.addRule(rule);
            }
            if (!rel.getTraitSet().equals(requiredOutputTraits)) {
                rel = planner.changeTraits(rel, requiredOutputTraits);
            }
            planner.setRoot(rel);
            return planner.findBestExp();
        }
    }
}

