/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.validate.AbstractNamespace;
import hive.org.apache.calcite.sql.validate.SqlMoniker;
import hive.org.apache.calcite.sql.validate.SqlValidatorImpl;
import hive.org.apache.calcite.sql.validate.SqlValidatorTable;
import hive.org.apache.calcite.util.Util;
import java.util.List;

class SchemaNamespace
extends AbstractNamespace {
    private final ImmutableList<String> names;

    SchemaNamespace(SqlValidatorImpl validator, ImmutableList<String> names) {
        super(validator, null);
        this.names = Preconditions.checkNotNull(names);
    }

    @Override
    protected RelDataType validateImpl() {
        RelDataTypeFactory.FieldInfoBuilder builder = this.validator.getTypeFactory().builder();
        for (SqlMoniker moniker : this.validator.catalogReader.getAllSchemaObjectNames(this.names)) {
            List<String> names1 = moniker.getFullyQualifiedNames();
            SqlValidatorTable table = this.validator.catalogReader.getTable(names1);
            builder.add(Util.last(names1), table.getRowType());
        }
        return builder.build();
    }

    @Override
    public SqlNode getNode() {
        return null;
    }
}

