/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.sql.validate.AbstractNamespace;
import hive.org.apache.calcite.sql.validate.SqlValidatorImpl;
import hive.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import hive.org.apache.calcite.util.Static;
import hive.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.List;

public class AliasNamespace
extends AbstractNamespace {
    protected final SqlCall call;

    protected AliasNamespace(SqlValidatorImpl validator, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.call = call;
        assert (call.getOperator() == SqlStdOperatorTable.AS);
    }

    @Override
    protected RelDataType validateImpl() {
        ArrayList<String> nameList = new ArrayList<String>();
        List<SqlNode> operands = this.call.getOperandList();
        SqlValidatorNamespace childNs = this.validator.getNamespace(operands.get(0));
        RelDataType rowType = childNs.getRowTypeSansSystemColumns();
        for (SqlNode operand : Util.skip(operands, 2)) {
            String name = ((SqlIdentifier)operand).getSimple();
            if (nameList.contains(name)) {
                throw this.validator.newValidationError(operand, Static.RESOURCE.aliasListDuplicate(name));
            }
            nameList.add(name);
        }
        if (nameList.size() != rowType.getFieldCount()) {
            throw this.validator.newValidationError(operands.get(2), Static.RESOURCE.aliasListDegree(rowType.getFieldCount(), this.getString(rowType), nameList.size()));
        }
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        for (RelDataTypeField field : rowType.getFieldList()) {
            typeList.add(field.getType());
        }
        return this.validator.getTypeFactory().createStructType(typeList, nameList);
    }

    private String getString(RelDataType rowType) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (RelDataTypeField field : rowType.getFieldList()) {
            if (field.getIndex() > 0) {
                buf.append(", ");
            }
            buf.append("'");
            buf.append(field.getName());
            buf.append("'");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public SqlNode getNode() {
        return this.call;
    }

    @Override
    public String translate(String name) {
        RelDataType underlyingRowType = this.validator.getValidatedNodeType((SqlNode)this.call.operand(0));
        int i = 0;
        for (RelDataTypeField field : this.rowType.getFieldList()) {
            if (field.getName().equals(name)) {
                return underlyingRowType.getFieldList().get(i).getName();
            }
            ++i;
        }
        throw new AssertionError((Object)("unknown field '" + name + "' in rowtype " + underlyingRowType));
    }
}

