/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.fun;

import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlFunction;
import hive.org.apache.calcite.sql.SqlFunctionCategory;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlLiteral;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlNodeList;
import hive.org.apache.calcite.sql.fun.SqlCase;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.type.OperandTypes;
import hive.org.apache.calcite.sql.type.ReturnTypes;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import java.util.List;

public class SqlNullifFunction
extends SqlFunction {
    public SqlNullifFunction() {
        super("NULLIF", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_FORCE_NULLABLE, null, OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        SqlParserPos pos = call.getParserPosition();
        this.checkOperandCount(validator, this.getOperandTypeChecker(), call);
        assert (operands.size() == 2);
        SqlNodeList whenList = new SqlNodeList(pos);
        SqlNodeList thenList = new SqlNodeList(pos);
        whenList.add(operands.get(1));
        thenList.add(SqlLiteral.createNull(SqlParserPos.ZERO));
        return SqlCase.createSwitched(pos, operands.get(0), whenList, thenList, operands.get(0).clone(operands.get(0).getParserPosition()));
    }
}

