/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.fun;

import hive.com.google.common.base.Preconditions;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlFunctionCategory;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperatorBinding;
import hive.org.apache.calcite.sql.SqlWriter;
import hive.org.apache.calcite.sql.fun.SqlMonotonicUnaryFunction;
import hive.org.apache.calcite.sql.type.OperandTypes;
import hive.org.apache.calcite.sql.type.ReturnTypes;
import hive.org.apache.calcite.sql.validate.SqlMonotonicity;

public class SqlFloorFunction
extends SqlMonotonicUnaryFunction {
    public SqlFloorFunction(SqlKind kind) {
        super(kind.name(), kind, ReturnTypes.ARG0_OR_EXACT_NO_SCALE, null, OperandTypes.or(OperandTypes.NUMERIC_OR_INTERVAL, OperandTypes.sequence("'" + (Object)((Object)kind) + "(<DATE> TO <TIME_UNIT>)'\n'" + (Object)((Object)kind) + "(<TIME> TO <TIME_UNIT>)'\n'" + (Object)((Object)kind) + "(<TIMESTAMP> TO <TIME_UNIT>)'", OperandTypes.DATETIME, OperandTypes.ANY)), SqlFunctionCategory.NUMERIC);
        Preconditions.checkArgument(kind == SqlKind.FLOOR || kind == SqlKind.CEIL);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return call.getOperandMonotonicity(0).unstrict();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        if (call.operandCount() == 2) {
            ((SqlNode)call.operand(0)).unparse(writer, 0, 100);
            writer.sep("TO");
            ((SqlNode)call.operand(1)).unparse(writer, 100, 0);
        } else {
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        }
        writer.endFunCall(frame);
    }
}

