/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.fun;

import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlFunction;
import hive.org.apache.calcite.sql.SqlFunctionCategory;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlNodeList;
import hive.org.apache.calcite.sql.fun.SqlCase;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.type.OperandTypes;
import hive.org.apache.calcite.sql.type.ReturnTypes;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.util.Util;
import java.util.List;

public class SqlCoalesceFunction
extends SqlFunction {
    public SqlCoalesceFunction() {
        super("COALESCE", SqlKind.OTHER_FUNCTION, ReturnTypes.LEAST_RESTRICTIVE, null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        this.validateQuantifier(validator, call);
        List<SqlNode> operands = call.getOperandList();
        if (operands.size() == 1) {
            return operands.get(0);
        }
        SqlParserPos pos = call.getParserPosition();
        SqlNodeList whenList = new SqlNodeList(pos);
        SqlNodeList thenList = new SqlNodeList(pos);
        int i = 0;
        while (i + 1 < operands.size()) {
            whenList.add(SqlStdOperatorTable.IS_NOT_NULL.createCall(pos, operands.get(i)));
            thenList.add(operands.get(i).clone(operands.get(i).getParserPosition()));
            ++i;
        }
        SqlNode elseExpr = Util.last(operands);
        assert (call.getFunctionQuantifier() == null);
        return SqlCase.createSwitched(pos, null, whenList, thenList, elseExpr);
    }
}

