/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql;

import hive.org.apache.calcite.util.Util;

public enum SqlFunctionCategory {
    STRING("STRING", "String function"),
    NUMERIC("NUMERIC", "Numeric function"),
    TIMEDATE("TIMEDATE", "Time and date function"),
    SYSTEM("SYSTEM", "System function"),
    USER_DEFINED_FUNCTION("UDF", "User-defined function"),
    USER_DEFINED_PROCEDURE("UDP", "User-defined procedure"),
    USER_DEFINED_CONSTRUCTOR("UDC", "User-defined constructor"),
    USER_DEFINED_SPECIFIC_FUNCTION("UDF_SPECIFIC", "User-defined function with SPECIFIC name"),
    USER_DEFINED_TABLE_FUNCTION("TABLE_UDF", "User-defined table function"),
    USER_DEFINED_TABLE_SPECIFIC_FUNCTION("TABLE_UDF_SPECIFIC", "User-defined table function with SPECIFIC name");


    private SqlFunctionCategory(String abbrev, String description) {
        Util.discard(abbrev);
        Util.discard(description);
    }

    public final boolean isUserdefined() {
        return this.isOneOf(USER_DEFINED_FUNCTION, USER_DEFINED_PROCEDURE, USER_DEFINED_CONSTRUCTOR, USER_DEFINED_SPECIFIC_FUNCTION, USER_DEFINED_TABLE_FUNCTION, USER_DEFINED_TABLE_SPECIFIC_FUNCTION);
    }

    public final boolean isTableFunction() {
        return this.isOneOf(USER_DEFINED_TABLE_FUNCTION, USER_DEFINED_TABLE_SPECIFIC_FUNCTION);
    }

    public final boolean isSpecific() {
        return this.isOneOf(USER_DEFINED_SPECIFIC_FUNCTION, USER_DEFINED_TABLE_SPECIFIC_FUNCTION);
    }

    public final boolean isUnresolvedUserDefinedFunction() {
        return this.isOneOf(USER_DEFINED_FUNCTION, USER_DEFINED_TABLE_FUNCTION);
    }

    public final boolean isOneOf(SqlFunctionCategory ... categories) {
        for (SqlFunctionCategory category : categories) {
            if (category != this) continue;
            return true;
        }
        return false;
    }
}

