/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.schema.impl;

import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.materialize.Lattice;
import hive.org.apache.calcite.plan.Convention;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.plan.RelTrait;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.schema.Schema;
import hive.org.apache.calcite.schema.Table;
import hive.org.apache.calcite.schema.TranslatableTable;
import hive.org.apache.calcite.schema.impl.AbstractTable;
import hive.org.apache.calcite.util.ImmutableIntList;
import hive.org.apache.calcite.util.Pair;
import java.util.ArrayList;
import java.util.List;

public class StarTable
extends AbstractTable
implements TranslatableTable {
    public final Lattice lattice;
    public final ImmutableList<Table> tables;
    public ImmutableIntList fieldCounts;

    private StarTable(Lattice lattice, ImmutableList<Table> tables) {
        this.lattice = Preconditions.checkNotNull(lattice);
        this.tables = tables;
    }

    public static StarTable of(Lattice lattice, List<Table> tables) {
        return new StarTable(lattice, ImmutableList.copyOf(tables));
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.STAR;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        ArrayList<Integer> fieldCounts = new ArrayList<Integer>();
        for (Table table : this.tables) {
            RelDataType rowType = table.getRowType(typeFactory);
            typeList.addAll(RelOptUtil.getFieldTypeList(rowType));
            fieldCounts.add(rowType.getFieldCount());
        }
        if (this.fieldCounts == null) {
            this.fieldCounts = ImmutableIntList.copyOf(fieldCounts);
        }
        return typeFactory.createStructType(typeList, this.lattice.uniqueColumnNames);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable table) {
        return new StarTableScan(context.getCluster(), table);
    }

    public StarTable add(Table table) {
        return StarTable.of(this.lattice, (List<Table>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.tables)).add(table)).build()));
    }

    public int columnOffset(Table table) {
        int n = 0;
        for (Pair<Table, Integer> pair : Pair.zip(this.tables, this.fieldCounts)) {
            if (pair.left == table) {
                return n;
            }
            n += ((Integer)pair.right).intValue();
        }
        throw new IllegalArgumentException("star table " + this + " does not contain table " + table);
    }

    public static class StarTableScan
    extends TableScan {
        public StarTableScan(RelOptCluster cluster, RelOptTable relOptTable) {
            super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), relOptTable);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeInfiniteCost();
        }
    }
}

