/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.runtime;

import hive.org.apache.calcite.linq4j.AbstractEnumerable;
import hive.org.apache.calcite.linq4j.Enumerable;
import hive.org.apache.calcite.linq4j.Enumerator;
import hive.org.apache.calcite.linq4j.function.Function0;
import hive.org.apache.calcite.linq4j.function.Function1;
import hive.org.apache.calcite.linq4j.tree.Primitive;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class ResultSetEnumerable<T>
extends AbstractEnumerable<T> {
    private final DataSource dataSource;
    private final String sql;
    private final Function1<ResultSet, Function0<T>> rowBuilderFactory;
    private static final Logger LOGGER = Logger.getLogger(ResultSetEnumerable.class.getName());
    private static final Function1<ResultSet, Function0<Object>> AUTO_ROW_BUILDER_FACTORY = new Function1<ResultSet, Function0<Object>>(){

        public Function0<Object> apply(final ResultSet resultSet) {
            int columnCount;
            ResultSetMetaData metaData;
            try {
                metaData = resultSet.getMetaData();
                columnCount = metaData.getColumnCount();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            if (columnCount == 1) {
                return new Function0<Object>(){

                    public Object apply() {
                        try {
                            return resultSet.getObject(1);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            return new Function0<Object[]>(){

                public Object[] apply() {
                    try {
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (int i = 0; i < columnCount; ++i) {
                            if (metaData.getColumnType(i + 1) == 93) {
                                long v = resultSet.getLong(i + 1);
                                if (v == 0L && resultSet.wasNull()) {
                                    list.add(null);
                                    continue;
                                }
                                list.add(v);
                                continue;
                            }
                            list.add(resultSet.getObject(i + 1));
                        }
                        return list.toArray();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    };

    private ResultSetEnumerable(DataSource dataSource, String sql, Function1<ResultSet, Function0<T>> rowBuilderFactory) {
        this.dataSource = dataSource;
        this.sql = sql;
        this.rowBuilderFactory = rowBuilderFactory;
    }

    public static Enumerable<Object> of(DataSource dataSource, String sql) {
        return ResultSetEnumerable.of(dataSource, sql, AUTO_ROW_BUILDER_FACTORY);
    }

    public static Enumerable<Object> of(DataSource dataSource, String sql, Primitive[] primitives) {
        return ResultSetEnumerable.of(dataSource, sql, ResultSetEnumerable.primitiveRowBuilderFactory(primitives));
    }

    public static <T> Enumerable<T> of(DataSource dataSource, String sql, Function1<ResultSet, Function0<T>> rowBuilderFactory) {
        return new ResultSetEnumerable<T>(dataSource, sql, rowBuilderFactory);
    }

    public Enumerator<T> enumerator() {
        Connection connection = null;
        Statement statement = null;
        try {
            block17: {
                connection = this.dataSource.getConnection();
                statement = connection.createStatement();
                try {
                    statement.setQueryTimeout(10);
                }
                catch (SQLFeatureNotSupportedException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block17;
                    LOGGER.fine("Failed to set query timeout.");
                }
            }
            ResultSet resultSet = statement.executeQuery(this.sql);
            statement = null;
            connection = null;
            ResultSetEnumerator<T> resultSetEnumerator = new ResultSetEnumerator<T>(resultSet, this.rowBuilderFactory);
            return resultSetEnumerator;
        }
        catch (SQLException e) {
            throw new RuntimeException("while executing SQL [" + this.sql + "]", e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static Function1<ResultSet, Function0<Object>> primitiveRowBuilderFactory(final Primitive[] primitives) {
        return new Function1<ResultSet, Function0<Object>>(){

            public Function0<Object> apply(final ResultSet resultSet) {
                int columnCount;
                try {
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    columnCount = metaData.getColumnCount();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                assert (columnCount == primitives.length);
                if (columnCount == 1) {
                    return new Function0<Object>(){

                        public Object apply() {
                            try {
                                return resultSet.getObject(1);
                            }
                            catch (SQLException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                return new Function0<Object[]>(){

                    public Object[] apply() {
                        try {
                            ArrayList<Object> list = new ArrayList<Object>();
                            for (int i = 0; i < columnCount; ++i) {
                                list.add(primitives[i].jdbcGet(resultSet, i + 1));
                            }
                            return list.toArray();
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    private static class ResultSetEnumerator<T>
    implements Enumerator<T> {
        private final Function0<T> rowBuilder;
        private ResultSet resultSet;

        public ResultSetEnumerator(ResultSet resultSet, Function1<ResultSet, Function0<T>> rowBuilderFactory) {
            this.resultSet = resultSet;
            this.rowBuilder = (Function0)rowBuilderFactory.apply((Object)resultSet);
        }

        public T current() {
            return (T)this.rowBuilder.apply();
        }

        public boolean moveNext() {
            try {
                return this.resultSet.next();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        public void reset() {
            try {
                this.resultSet.beforeFirst();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            ResultSet savedResultSet = this.resultSet;
            if (savedResultSet != null) {
                try {
                    this.resultSet = null;
                    Statement statement = savedResultSet.getStatement();
                    savedResultSet.close();
                    if (statement != null) {
                        Connection connection = statement.getConnection();
                        statement.close();
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }
}

