/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rex;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.DataContext;
import hive.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.BlockStatement;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.IndexExpression;
import hive.org.apache.calcite.linq4j.tree.MethodCallExpression;
import hive.org.apache.calcite.linq4j.tree.MethodDeclaration;
import hive.org.apache.calcite.linq4j.tree.Node;
import hive.org.apache.calcite.linq4j.tree.ParameterExpression;
import hive.org.apache.calcite.linq4j.tree.Statement;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.prepare.CalcitePrepareImpl;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexExecutable;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexProgramBuilder;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.Util;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

public class RexExecutorImpl
implements RelOptPlanner.Executor {
    private final DataContext dataContext;

    public RexExecutorImpl(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    private String compile(RexBuilder rexBuilder, List<RexNode> constExps, RexToLixTranslator.InputGetter getter) {
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        RelDataType emptyRowType = typeFactory.builder().build();
        return this.compile(rexBuilder, constExps, getter, emptyRowType);
    }

    private String compile(RexBuilder rexBuilder, List<RexNode> constExps, RexToLixTranslator.InputGetter getter, RelDataType rowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(rowType, rexBuilder);
        for (RexNode node : constExps) {
            programBuilder.addProject(node, "c" + programBuilder.getProjectList().size());
        }
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl(rexBuilder.getTypeFactory().getTypeSystem());
        BlockBuilder blockBuilder = new BlockBuilder();
        ParameterExpression root0_ = Expressions.parameter(Object.class, (String)"root0");
        ParameterExpression root_ = DataContext.ROOT;
        blockBuilder.add((Statement)Expressions.declare((int)16, (ParameterExpression)root_, (Expression)Expressions.convert_((Expression)root0_, DataContext.class)));
        List<Expression> expressions = RexToLixTranslator.translateProjects(programBuilder.getProgram(), javaTypeFactory, blockBuilder, null, (Expression)root_, getter, null);
        blockBuilder.add((Statement)Expressions.return_(null, (Expression)Expressions.newArrayInit(Object[].class, expressions)));
        MethodDeclaration methodDecl = Expressions.methodDecl((int)1, Object[].class, (String)BuiltInMethod.FUNCTION1_APPLY.method.getName(), ImmutableList.of(root0_), (BlockStatement)blockBuilder.toBlock());
        String code = Expressions.toString((Node)methodDecl);
        if (CalcitePrepareImpl.DEBUG) {
            Util.debugCode(System.out, code);
        }
        return code;
    }

    public RexExecutable getExecutable(RexBuilder rexBuilder, List<RexNode> exps, RelDataType rowType) {
        DataContextInputGetter getter = new DataContextInputGetter(rowType, rexBuilder.getTypeFactory());
        String code = this.compile(rexBuilder, exps, getter, rowType);
        return new RexExecutable(code, "generated Rex code");
    }

    @Override
    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        String code = this.compile(rexBuilder, constExps, new RexToLixTranslator.InputGetter(){

            @Override
            public Expression field(BlockBuilder list, int index, Type storageType) {
                throw new UnsupportedOperationException();
            }
        });
        RexExecutable executable = new RexExecutable(code, constExps);
        executable.setDataContext(this.dataContext);
        executable.reduce(rexBuilder, constExps, reducedValues);
    }

    private static class DataContextInputGetter
    implements RexToLixTranslator.InputGetter {
        private final RelDataTypeFactory typeFactory;
        private final RelDataType rowType;

        public DataContextInputGetter(RelDataType rowType, RelDataTypeFactory typeFactory) {
            this.rowType = rowType;
            this.typeFactory = typeFactory;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type storageType) {
            MethodCallExpression recFromCtx = Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)"inputRecord")});
            Expression recFromCtxCasted = RexToLixTranslator.convert((Expression)recFromCtx, Object[].class);
            IndexExpression recordAccess = Expressions.arrayIndex((Expression)recFromCtxCasted, (Expression)Expressions.constant((Object)index));
            if (storageType == null) {
                RelDataType fieldType = this.rowType.getFieldList().get(index).getType();
                storageType = ((JavaTypeFactory)this.typeFactory).getJavaClass(fieldType);
            }
            return RexToLixTranslator.convert((Expression)recordAccess, storageType);
        }
    }
}

