/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.type;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rel.type.RelDataTypeSystem;
import hive.org.apache.calcite.sql.type.SqlTypeFamily;
import hive.org.apache.calcite.sql.type.SqlTypeName;

public abstract class RelDataTypeSystemImpl
implements RelDataTypeSystem {
    @Override
    public int getMaxScale(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericScale();
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 9;
            }
        }
        return -1;
    }

    @Override
    public int getDefaultPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case CHAR: 
            case BINARY: 
            case VARCHAR: 
            case VARBINARY: {
                return 1;
            }
            case DECIMAL: {
                return this.getMaxNumericPrecision();
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 2;
            }
            case BOOLEAN: {
                return 1;
            }
            case TINYINT: {
                return 3;
            }
            case SMALLINT: {
                return 5;
            }
            case INTEGER: {
                return 10;
            }
            case BIGINT: {
                return 19;
            }
            case REAL: {
                return 7;
            }
            case FLOAT: 
            case DOUBLE: {
                return 15;
            }
            case TIME: 
            case DATE: {
                return 0;
            }
            case TIMESTAMP: {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public int getMaxPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericPrecision();
            }
            case CHAR: 
            case VARCHAR: {
                return 65536;
            }
            case BINARY: 
            case VARBINARY: {
                return 65536;
            }
            case TIME: 
            case TIMESTAMP: {
                return 3;
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return 10;
            }
        }
        return this.getDefaultPrecision(typeName);
    }

    @Override
    public int getMaxNumericScale() {
        return 19;
    }

    @Override
    public int getMaxNumericPrecision() {
        return 19;
    }

    @Override
    public String getLiteral(SqlTypeName typeName, boolean isPrefix) {
        switch (typeName) {
            case CHAR: 
            case VARCHAR: 
            case VARBINARY: {
                return "'";
            }
            case BINARY: {
                return isPrefix ? "x'" : "'";
            }
            case TIMESTAMP: {
                return isPrefix ? "TIMESTAMP '" : "'";
            }
            case INTERVAL_DAY_TIME: {
                return isPrefix ? "INTERVAL '" : "' DAY";
            }
            case INTERVAL_YEAR_MONTH: {
                return isPrefix ? "INTERVAL '" : "' YEAR TO MONTH";
            }
            case TIME: {
                return isPrefix ? "TIME '" : "'";
            }
            case DATE: {
                return isPrefix ? "DATE '" : "'";
            }
            case ARRAY: {
                return isPrefix ? "(" : ")";
            }
        }
        return null;
    }

    @Override
    public boolean isCaseSensitive(SqlTypeName typeName) {
        switch (typeName) {
            case CHAR: 
            case VARCHAR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAutoincrement(SqlTypeName typeName) {
        return false;
    }

    @Override
    public int getNumTypeRadix(SqlTypeName typeName) {
        if (typeName.getFamily() == SqlTypeFamily.NUMERIC && this.getDefaultPrecision(typeName) != -1) {
            return 10;
        }
        return 0;
    }

    @Override
    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        return argumentType;
    }

    @Override
    public boolean isSchemaCaseSensitive() {
        return true;
    }
}

