/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollationTraitDef;
import hive.org.apache.calcite.rel.RelCollations;
import hive.org.apache.calcite.rel.RelFieldCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.logical.LogicalJoin;
import hive.org.apache.calcite.rel.logical.LogicalSort;
import hive.org.apache.calcite.rel.metadata.RelMdUtil;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;

public class SortJoinTransposeRule
extends RelOptRule {
    public static final SortJoinTransposeRule INSTANCE = new SortJoinTransposeRule(LogicalSort.class, LogicalJoin.class);

    public SortJoinTransposeRule(Class<? extends Sort> sortClass, Class<? extends Join> joinClass) {
        super(SortJoinTransposeRule.operand(sortClass, SortJoinTransposeRule.operand(joinClass, SortJoinTransposeRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        Join join = (Join)call.rel(1);
        if (join.getJoinType() == JoinRelType.LEFT) {
            if (sort.getCollation() != RelCollations.EMPTY) {
                for (RelFieldCollation relFieldCollation : sort.getCollation().getFieldCollations()) {
                    if (relFieldCollation.getFieldIndex() < join.getLeft().getRowType().getFieldCount()) continue;
                    return false;
                }
            }
        } else if (join.getJoinType() == JoinRelType.RIGHT) {
            if (sort.getCollation() != RelCollations.EMPTY) {
                for (RelFieldCollation relFieldCollation : sort.getCollation().getFieldCollations()) {
                    if (relFieldCollation.getFieldIndex() >= join.getLeft().getRowType().getFieldCount()) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode newRightInput;
        RelNode newLeftInput;
        Sort sort = (Sort)call.rel(0);
        Join join = (Join)call.rel(1);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        if (join.getJoinType() == JoinRelType.LEFT) {
            if (RelMdUtil.checkInputForCollationAndLimit(mq, join.getLeft(), sort.getCollation(), sort.offset, sort.fetch)) {
                return;
            }
            newLeftInput = sort.copy(sort.getTraitSet(), join.getLeft(), sort.getCollation(), sort.offset, sort.fetch);
            newRightInput = join.getRight();
        } else {
            RelCollation rightCollation = RelCollationTraitDef.INSTANCE.canonize(RelCollations.shift(sort.getCollation(), -join.getLeft().getRowType().getFieldCount()));
            if (RelMdUtil.checkInputForCollationAndLimit(mq, join.getRight(), rightCollation, sort.offset, sort.fetch)) {
                return;
            }
            newLeftInput = join.getLeft();
            newRightInput = sort.copy(sort.getTraitSet().replace(rightCollation), join.getRight(), rightCollation, sort.offset, sort.fetch);
        }
        Join joinCopy = join.copy(join.getTraitSet(), join.getCondition(), newLeftInput, newRightInput, join.getJoinType(), join.isSemiJoinDone());
        Sort sortCopy = sort.copy(sort.getTraitSet(), joinCopy, sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo(sortCopy);
    }
}

