/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.logical.LogicalJoin;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.Util;
import java.util.List;

public class JoinCommuteRule
extends RelOptRule {
    public static final JoinCommuteRule INSTANCE = new JoinCommuteRule(false);
    public static final JoinCommuteRule SWAP_OUTER = new JoinCommuteRule(true);
    private final RelFactories.ProjectFactory projectFactory;
    private final boolean swapOuter;

    private JoinCommuteRule(boolean swapOuter) {
        this(LogicalJoin.class, RelFactories.DEFAULT_PROJECT_FACTORY, swapOuter);
    }

    @Deprecated
    public JoinCommuteRule(Class<? extends Join> clazz, RelFactories.ProjectFactory projectFactory) {
        this(clazz, projectFactory, false);
    }

    public JoinCommuteRule(Class<? extends Join> clazz, RelFactories.ProjectFactory projectFactory, boolean swapOuter) {
        super(JoinCommuteRule.operand(clazz, JoinCommuteRule.any()));
        this.projectFactory = projectFactory;
        this.swapOuter = swapOuter;
    }

    public static RelNode swap(Join join) {
        return JoinCommuteRule.swap(join, false);
    }

    public static RelNode swap(Join join, boolean swapOuterJoins) {
        JoinRelType joinType = join.getJoinType();
        if (!swapOuterJoins && joinType != JoinRelType.INNER) {
            return null;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelDataType leftRowType = join.getLeft().getRowType();
        RelDataType rightRowType = join.getRight().getRowType();
        VariableReplacer variableReplacer = new VariableReplacer(rexBuilder, leftRowType, rightRowType);
        RexNode oldCondition = join.getCondition();
        RexNode condition = variableReplacer.go(oldCondition);
        Join newJoin = join.copy(join.getTraitSet(), condition, join.getRight(), join.getLeft(), joinType.swap(), join.isSemiJoinDone());
        List<RexNode> exps = RelOptUtil.createSwappedJoinExprs(newJoin, join, true);
        return RelOptUtil.createProject((RelNode)newJoin, exps, join.getRowType().getFieldNames(), true);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        if (!join.getSystemFieldList().isEmpty()) {
            return;
        }
        RelNode swapped = JoinCommuteRule.swap(join, this.swapOuter);
        if (swapped == null) {
            return;
        }
        Join newJoin = swapped instanceof Join ? (Join)swapped : (Join)swapped.getInput(0);
        call.transformTo(swapped);
        List<RexNode> exps = RelOptUtil.createSwappedJoinExprs(newJoin, join, false);
        RelNode project = this.projectFactory.createProject(swapped, exps, newJoin.getRowType().getFieldNames());
        RelNode rel = call.getPlanner().ensureRegistered(project, newJoin);
        Util.discard(rel);
    }

    private static class VariableReplacer {
        private final RexBuilder rexBuilder;
        private final List<RelDataTypeField> leftFields;
        private final List<RelDataTypeField> rightFields;

        VariableReplacer(RexBuilder rexBuilder, RelDataType leftType, RelDataType rightType) {
            this.rexBuilder = rexBuilder;
            this.leftFields = leftType.getFieldList();
            this.rightFields = rightType.getFieldList();
        }

        public RexNode go(RexNode rex) {
            if (rex instanceof RexCall) {
                ImmutableList.Builder builder = ImmutableList.builder();
                RexCall call = (RexCall)rex;
                for (RexNode operand : call.operands) {
                    builder.add(this.go(operand));
                }
                return call.clone(call.getType(), (List<RexNode>)((Object)builder.build()));
            }
            if (rex instanceof RexInputRef) {
                RexInputRef var = (RexInputRef)rex;
                int index = var.getIndex();
                if (index < this.leftFields.size()) {
                    return this.rexBuilder.makeInputRef(this.leftFields.get(index).getType(), this.rightFields.size() + index);
                }
                if ((index -= this.leftFields.size()) < this.rightFields.size()) {
                    return this.rexBuilder.makeInputRef(this.rightFields.get(index).getType(), index);
                }
                throw Util.newInternal("Bad field offset: index=" + var.getIndex() + ", leftFieldCount=" + this.leftFields.size() + ", rightFieldCount=" + this.rightFields.size());
            }
            return rex;
        }
    }
}

