/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Correlate;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.List;

public class FilterCorrelateRule
extends RelOptRule {
    public static final FilterCorrelateRule INSTANCE = new FilterCorrelateRule(RelFactories.DEFAULT_FILTER_FACTORY, RelFactories.DEFAULT_PROJECT_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    public FilterCorrelateRule(RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory) {
        super(FilterCorrelateRule.operand(Filter.class, FilterCorrelateRule.operand(Correlate.class, RelOptRule.any()), new RelOptRuleOperand[0]), "FilterCorrelateRule");
        this.filterFactory = filterFactory;
        Util.discard(projectFactory);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Correlate corr = (Correlate)call.rel(1);
        List<RexNode> aboveFilters = RelOptUtil.conjunctions(filter.getCondition());
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        RelOptUtil.classifyFilters(corr, aboveFilters, JoinRelType.INNER, false, !corr.getJoinType().toJoinType().generatesNullsOnLeft(), !corr.getJoinType().toJoinType().generatesNullsOnRight(), aboveFilters, leftFilters, rightFilters);
        if (leftFilters.isEmpty() && rightFilters.isEmpty()) {
            return;
        }
        RexBuilder rexBuilder = corr.getCluster().getRexBuilder();
        RelNode leftRel = RelOptUtil.createFilter(corr.getLeft(), leftFilters, this.filterFactory);
        RelNode rightRel = RelOptUtil.createFilter(corr.getRight(), rightFilters, this.filterFactory);
        RelNode newCorrRel = corr.copy(corr.getTraitSet(), ImmutableList.of(leftRel, rightRel));
        call.getPlanner().onCopy(corr, newCorrRel);
        if (!leftFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, leftRel);
        }
        if (!rightFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, rightRel);
        }
        RelNode newRel = RelOptUtil.createFilter(newCorrRel, RexUtil.fixUp(rexBuilder, aboveFilters, newCorrRel.getRowType()), this.filterFactory);
        call.transformTo(newRel);
    }
}

