/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Iterables;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPredicateList;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelDistribution;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.metadata.BuiltInMetadata;
import hive.org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.Metadata;
import hive.org.apache.calcite.rel.metadata.MetadataDef;
import hive.org.apache.calcite.rel.metadata.MetadataHandler;
import hive.org.apache.calcite.rel.metadata.RelColumnOrigin;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.sql.SqlExplainLevel;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelMetadataQuery {
    public final Map<List, Object> map = new HashMap<List, Object>();
    public final JaninoRelMetadataProvider metadataProvider;
    protected static final RelMetadataQuery EMPTY = new RelMetadataQuery(false);
    private BuiltInMetadata.Collation.Handler collationHandler;
    private BuiltInMetadata.ColumnOrigin.Handler columnOriginHandler;
    private BuiltInMetadata.ColumnUniqueness.Handler columnUniquenessHandler;
    private BuiltInMetadata.CumulativeCost.Handler cumulativeCostHandler;
    private BuiltInMetadata.DistinctRowCount.Handler distinctRowCountHandler;
    private BuiltInMetadata.Distribution.Handler distributionHandler;
    private BuiltInMetadata.ExplainVisibility.Handler explainVisibilityHandler;
    private BuiltInMetadata.MaxRowCount.Handler maxRowCountHandler;
    private BuiltInMetadata.Memory.Handler memoryHandler;
    private BuiltInMetadata.NonCumulativeCost.Handler nonCumulativeCostHandler;
    private BuiltInMetadata.Parallelism.Handler parallelismHandler;
    private BuiltInMetadata.PercentageOriginalRows.Handler percentageOriginalRowsHandler;
    private BuiltInMetadata.PopulationSize.Handler populationSizeHandler;
    private BuiltInMetadata.Predicates.Handler predicatesHandler;
    private BuiltInMetadata.RowCount.Handler rowCountHandler;
    private BuiltInMetadata.Selectivity.Handler selectivityHandler;
    private BuiltInMetadata.Size.Handler sizeHandler;
    private BuiltInMetadata.UniqueKeys.Handler uniqueKeysHandler;
    public static final ThreadLocal<JaninoRelMetadataProvider> THREAD_PROVIDERS = new ThreadLocal<JaninoRelMetadataProvider>(){

        @Override
        protected JaninoRelMetadataProvider initialValue() {
            return JaninoRelMetadataProvider.DEFAULT;
        }
    };

    protected RelMetadataQuery(JaninoRelMetadataProvider metadataProvider, RelMetadataQuery prototype) {
        this.metadataProvider = Preconditions.checkNotNull(metadataProvider);
        this.collationHandler = prototype.collationHandler;
        this.columnOriginHandler = prototype.columnOriginHandler;
        this.columnUniquenessHandler = prototype.columnUniquenessHandler;
        this.cumulativeCostHandler = prototype.cumulativeCostHandler;
        this.distinctRowCountHandler = prototype.distinctRowCountHandler;
        this.distributionHandler = prototype.distributionHandler;
        this.explainVisibilityHandler = prototype.explainVisibilityHandler;
        this.maxRowCountHandler = prototype.maxRowCountHandler;
        this.memoryHandler = prototype.memoryHandler;
        this.nonCumulativeCostHandler = prototype.nonCumulativeCostHandler;
        this.parallelismHandler = prototype.parallelismHandler;
        this.percentageOriginalRowsHandler = prototype.percentageOriginalRowsHandler;
        this.populationSizeHandler = prototype.populationSizeHandler;
        this.predicatesHandler = prototype.predicatesHandler;
        this.rowCountHandler = prototype.rowCountHandler;
        this.selectivityHandler = prototype.selectivityHandler;
        this.sizeHandler = prototype.sizeHandler;
        this.uniqueKeysHandler = prototype.uniqueKeysHandler;
    }

    protected static <H> H initialHandler(Class<H> handlerClass) {
        return handlerClass.cast(Proxy.newProxyInstance(RelMetadataQuery.class.getClassLoader(), new Class[]{handlerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RelNode r = (RelNode)args[0];
                throw new JaninoRelMetadataProvider.NoHandler(r.getClass());
            }
        }));
    }

    public static RelMetadataQuery instance() {
        return new RelMetadataQuery(THREAD_PROVIDERS.get(), EMPTY);
    }

    private RelMetadataQuery(boolean dummy) {
        this.metadataProvider = null;
        this.collationHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Collation.Handler.class);
        this.columnOriginHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.ColumnOrigin.Handler.class);
        this.columnUniquenessHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.ColumnUniqueness.Handler.class);
        this.cumulativeCostHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.CumulativeCost.Handler.class);
        this.distinctRowCountHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.DistinctRowCount.Handler.class);
        this.distributionHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Distribution.Handler.class);
        this.explainVisibilityHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.ExplainVisibility.Handler.class);
        this.maxRowCountHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.MaxRowCount.Handler.class);
        this.memoryHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Memory.Handler.class);
        this.nonCumulativeCostHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.NonCumulativeCost.Handler.class);
        this.parallelismHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Parallelism.Handler.class);
        this.percentageOriginalRowsHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.PercentageOriginalRows.Handler.class);
        this.populationSizeHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.PopulationSize.Handler.class);
        this.predicatesHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Predicates.Handler.class);
        this.rowCountHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.RowCount.Handler.class);
        this.selectivityHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Selectivity.Handler.class);
        this.sizeHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Size.Handler.class);
        this.uniqueKeysHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.UniqueKeys.Handler.class);
    }

    protected <M extends Metadata, H extends MetadataHandler<M>> H revise(Class<? extends RelNode> class_, MetadataDef<M> def) {
        return this.metadataProvider.revise(class_, def);
    }

    public Double getRowCount(RelNode rel) {
        while (true) {
            try {
                Double result = this.rowCountHandler.getRowCount(rel, this);
                return RelMetadataQuery.validateResult(result);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.rowCountHandler = (BuiltInMetadata.RowCount.Handler)this.revise(e.relClass, BuiltInMetadata.RowCount.DEF);
                continue;
            }
            break;
        }
    }

    public Double getMaxRowCount(RelNode rel) {
        while (true) {
            try {
                return this.maxRowCountHandler.getMaxRowCount(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.maxRowCountHandler = (BuiltInMetadata.MaxRowCount.Handler)this.revise(e.relClass, BuiltInMetadata.MaxRowCount.DEF);
                continue;
            }
            break;
        }
    }

    public RelOptCost getCumulativeCost(RelNode rel) {
        while (true) {
            try {
                return this.cumulativeCostHandler.getCumulativeCost(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.cumulativeCostHandler = (BuiltInMetadata.CumulativeCost.Handler)this.revise(e.relClass, BuiltInMetadata.CumulativeCost.DEF);
                continue;
            }
            break;
        }
    }

    public RelOptCost getNonCumulativeCost(RelNode rel) {
        while (true) {
            try {
                return this.nonCumulativeCostHandler.getNonCumulativeCost(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.nonCumulativeCostHandler = (BuiltInMetadata.NonCumulativeCost.Handler)this.revise(e.relClass, BuiltInMetadata.NonCumulativeCost.DEF);
                continue;
            }
            break;
        }
    }

    public Double getPercentageOriginalRows(RelNode rel) {
        while (true) {
            try {
                Double result = this.percentageOriginalRowsHandler.getPercentageOriginalRows(rel, this);
                return RelMetadataQuery.validatePercentage(result);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.percentageOriginalRowsHandler = (BuiltInMetadata.PercentageOriginalRows.Handler)this.revise(e.relClass, BuiltInMetadata.PercentageOriginalRows.DEF);
                continue;
            }
            break;
        }
    }

    public Set<RelColumnOrigin> getColumnOrigins(RelNode rel, int column) {
        while (true) {
            try {
                return this.columnOriginHandler.getColumnOrigins(rel, this, column);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.columnOriginHandler = (BuiltInMetadata.ColumnOrigin.Handler)this.revise(e.relClass, BuiltInMetadata.ColumnOrigin.DEF);
                continue;
            }
            break;
        }
    }

    public RelColumnOrigin getColumnOrigin(RelNode rel, int column) {
        Set<RelColumnOrigin> origins = this.getColumnOrigins(rel, column);
        if (origins == null || origins.size() != 1) {
            return null;
        }
        RelColumnOrigin origin = Iterables.getOnlyElement(origins);
        return origin.isDerived() ? null : origin;
    }

    public RelOptTable getTableOrigin(RelNode rel) {
        Set<RelColumnOrigin> colOrigins = this.getColumnOrigins(rel, 0);
        if (colOrigins == null || colOrigins.size() == 0) {
            return null;
        }
        return colOrigins.iterator().next().getOriginTable();
    }

    public Double getSelectivity(RelNode rel, RexNode predicate) {
        while (true) {
            try {
                Double result = this.selectivityHandler.getSelectivity(rel, this, predicate);
                return RelMetadataQuery.validatePercentage(result);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.selectivityHandler = (BuiltInMetadata.Selectivity.Handler)this.revise(e.relClass, BuiltInMetadata.Selectivity.DEF);
                continue;
            }
            break;
        }
    }

    public Set<ImmutableBitSet> getUniqueKeys(RelNode rel) {
        return this.getUniqueKeys(rel, false);
    }

    public Set<ImmutableBitSet> getUniqueKeys(RelNode rel, boolean ignoreNulls) {
        while (true) {
            try {
                return this.uniqueKeysHandler.getUniqueKeys(rel, this, ignoreNulls);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.uniqueKeysHandler = (BuiltInMetadata.UniqueKeys.Handler)this.revise(e.relClass, BuiltInMetadata.UniqueKeys.DEF);
                continue;
            }
            break;
        }
    }

    public Boolean areRowsUnique(RelNode rel) {
        ImmutableBitSet columns = ImmutableBitSet.range(rel.getRowType().getFieldCount());
        return this.areColumnsUnique(rel, columns, false);
    }

    public Boolean areColumnsUnique(RelNode rel, ImmutableBitSet columns) {
        return this.areColumnsUnique(rel, columns, false);
    }

    public Boolean areColumnsUnique(RelNode rel, ImmutableBitSet columns, boolean ignoreNulls) {
        while (true) {
            try {
                return this.columnUniquenessHandler.areColumnsUnique(rel, this, columns, ignoreNulls);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.columnUniquenessHandler = (BuiltInMetadata.ColumnUniqueness.Handler)this.revise(e.relClass, BuiltInMetadata.ColumnUniqueness.DEF);
                continue;
            }
            break;
        }
    }

    public ImmutableList<RelCollation> collations(RelNode rel) {
        while (true) {
            try {
                return this.collationHandler.collations(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.collationHandler = (BuiltInMetadata.Collation.Handler)this.revise(e.relClass, BuiltInMetadata.Collation.DEF);
                continue;
            }
            break;
        }
    }

    public RelDistribution distribution(RelNode rel) {
        while (true) {
            try {
                return this.distributionHandler.distribution(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.distributionHandler = (BuiltInMetadata.Distribution.Handler)this.revise(e.relClass, BuiltInMetadata.Distribution.DEF);
                continue;
            }
            break;
        }
    }

    public Double getPopulationSize(RelNode rel, ImmutableBitSet groupKey) {
        while (true) {
            try {
                Double result = this.populationSizeHandler.getPopulationSize(rel, this, groupKey);
                return RelMetadataQuery.validateResult(result);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.populationSizeHandler = (BuiltInMetadata.PopulationSize.Handler)this.revise(e.relClass, BuiltInMetadata.PopulationSize.DEF);
                continue;
            }
            break;
        }
    }

    public Double getAverageRowSize(RelNode rel) {
        while (true) {
            try {
                return this.sizeHandler.averageRowSize(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.sizeHandler = (BuiltInMetadata.Size.Handler)this.revise(e.relClass, BuiltInMetadata.Size.DEF);
                continue;
            }
            break;
        }
    }

    public List<Double> getAverageColumnSizes(RelNode rel) {
        while (true) {
            try {
                return this.sizeHandler.averageColumnSizes(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.sizeHandler = (BuiltInMetadata.Size.Handler)this.revise(e.relClass, BuiltInMetadata.Size.DEF);
                continue;
            }
            break;
        }
    }

    public List<Double> getAverageColumnSizesNotNull(RelNode rel) {
        List<Double> averageColumnSizes = this.getAverageColumnSizes(rel);
        return averageColumnSizes == null ? Collections.nCopies(rel.getRowType().getFieldCount(), null) : averageColumnSizes;
    }

    public Boolean isPhaseTransition(RelNode rel) {
        while (true) {
            try {
                return this.parallelismHandler.isPhaseTransition(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.parallelismHandler = (BuiltInMetadata.Parallelism.Handler)this.revise(e.relClass, BuiltInMetadata.Parallelism.DEF);
                continue;
            }
            break;
        }
    }

    public Integer splitCount(RelNode rel) {
        while (true) {
            try {
                return this.parallelismHandler.splitCount(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.parallelismHandler = (BuiltInMetadata.Parallelism.Handler)this.revise(e.relClass, BuiltInMetadata.Parallelism.DEF);
                continue;
            }
            break;
        }
    }

    public Double memory(RelNode rel) {
        while (true) {
            try {
                return this.memoryHandler.memory(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.memoryHandler = (BuiltInMetadata.Memory.Handler)this.revise(e.relClass, BuiltInMetadata.Memory.DEF);
                continue;
            }
            break;
        }
    }

    public Double cumulativeMemoryWithinPhase(RelNode rel) {
        while (true) {
            try {
                return this.memoryHandler.cumulativeMemoryWithinPhase(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.memoryHandler = (BuiltInMetadata.Memory.Handler)this.revise(e.relClass, BuiltInMetadata.Memory.DEF);
                continue;
            }
            break;
        }
    }

    public Double cumulativeMemoryWithinPhaseSplit(RelNode rel) {
        while (true) {
            try {
                return this.memoryHandler.cumulativeMemoryWithinPhaseSplit(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.memoryHandler = (BuiltInMetadata.Memory.Handler)this.revise(e.relClass, BuiltInMetadata.Memory.DEF);
                continue;
            }
            break;
        }
    }

    public Double getDistinctRowCount(RelNode rel, ImmutableBitSet groupKey, RexNode predicate) {
        while (true) {
            try {
                Double result = this.distinctRowCountHandler.getDistinctRowCount(rel, this, groupKey, predicate);
                return RelMetadataQuery.validateResult(result);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.distinctRowCountHandler = (BuiltInMetadata.DistinctRowCount.Handler)this.revise(e.relClass, BuiltInMetadata.DistinctRowCount.DEF);
                continue;
            }
            break;
        }
    }

    public RelOptPredicateList getPulledUpPredicates(RelNode rel) {
        while (true) {
            try {
                return this.predicatesHandler.getPredicates(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.predicatesHandler = (BuiltInMetadata.Predicates.Handler)this.revise(e.relClass, BuiltInMetadata.Predicates.DEF);
                continue;
            }
            break;
        }
    }

    public boolean isVisibleInExplain(RelNode rel, SqlExplainLevel explainLevel) {
        while (true) {
            try {
                Boolean b = this.explainVisibilityHandler.isVisibleInExplain(rel, this, explainLevel);
                return b == null || b != false;
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.explainVisibilityHandler = (BuiltInMetadata.ExplainVisibility.Handler)this.revise(e.relClass, BuiltInMetadata.ExplainVisibility.DEF);
                continue;
            }
            break;
        }
    }

    private static Double validatePercentage(Double result) {
        assert (RelMetadataQuery.isPercentage(result, true));
        return result;
    }

    public RelDistribution getDistribution(RelNode rel) {
        BuiltInMetadata.Distribution metadata = rel.metadata(BuiltInMetadata.Distribution.class, this);
        return metadata.distribution();
    }

    private static boolean isPercentage(Double result, boolean fail) {
        if (result != null) {
            double d = result;
            if (d < 0.0) {
                assert (!fail);
                return false;
            }
            if (d > 1.0) {
                assert (!fail);
                return false;
            }
        }
        return true;
    }

    private static boolean isNonNegative(Double result, boolean fail) {
        double d;
        if (result != null && (d = result.doubleValue()) < 0.0) {
            assert (!fail);
            return false;
        }
        return true;
    }

    private static Double validateResult(Double result) {
        if (result == null) {
            return null;
        }
        if (result.isInfinite()) {
            result = Double.MAX_VALUE;
        }
        assert (RelMetadataQuery.isNonNegative(result, true));
        if (result < 1.0) {
            result = 1.0;
        }
        return result;
    }
}

