/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.core.Union;
import hive.org.apache.calcite.rel.metadata.BuiltInMetadata;
import hive.org.apache.calcite.rel.metadata.MetadataDef;
import hive.org.apache.calcite.rel.metadata.MetadataHandler;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMdUtil;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.ArrayList;

public class RelMdSelectivity
implements MetadataHandler<BuiltInMetadata.Selectivity> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.SELECTIVITY.method, new RelMdSelectivity());

    protected RelMdSelectivity() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Selectivity> getDef() {
        return BuiltInMetadata.Selectivity.DEF;
    }

    public Double getSelectivity(Union rel, RelMetadataQuery mq, RexNode predicate) {
        if (rel.getInputs().size() == 0 || predicate == null) {
            return 1.0;
        }
        double sumRows = 0.0;
        double sumSelectedRows = 0.0;
        int[] adjustments = new int[rel.getRowType().getFieldCount()];
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        for (RelNode input : rel.getInputs()) {
            Double nRows = mq.getRowCount(input);
            if (nRows == null) {
                return null;
            }
            RexNode modifiedPred = predicate.accept(new RelOptUtil.RexInputConverter(rexBuilder, null, input.getRowType().getFieldList(), adjustments));
            double sel = mq.getSelectivity(input, modifiedPred);
            sumRows += nRows.doubleValue();
            sumSelectedRows += nRows * sel;
        }
        if (sumRows < 1.0) {
            sumRows = 1.0;
        }
        return sumSelectedRows / sumRows;
    }

    public Double getSelectivity(Sort rel, RelMetadataQuery mq, RexNode predicate) {
        return mq.getSelectivity(rel.getInput(), predicate);
    }

    public Double getSelectivity(Filter rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds(rel.getCluster().getRexBuilder(), predicate, rel.getCondition()));
        }
        return mq.getSelectivity(rel.getInput(), rel.getCondition());
    }

    public Double getSelectivity(SemiJoin rel, RelMetadataQuery mq, RexNode predicate) {
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode newPred = RelMdUtil.makeSemiJoinSelectivityRexNode(mq, rel);
        if (predicate != null) {
            newPred = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newPred, predicate);
        }
        return mq.getSelectivity(rel.getLeft(), newPred);
    }

    public Double getSelectivity(Aggregate rel, RelMetadataQuery mq, RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(rel.getGroupSet(), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        Double selectivity = mq.getSelectivity(rel.getInput(), childPred);
        if (selectivity == null) {
            return null;
        }
        RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return selectivity * RelMdUtil.guessSelectivity(pred);
    }

    public Double getSelectivity(Project rel, RelMetadataQuery mq, RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(ImmutableBitSet.range(rel.getRowType().getFieldCount()), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        RexNode modifiedPred = childPred == null ? null : RelOptUtil.pushPastProject(childPred, rel);
        Double selectivity = mq.getSelectivity(rel.getInput(), modifiedPred);
        if (selectivity == null) {
            return null;
        }
        RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return selectivity * RelMdUtil.guessSelectivity(pred);
    }

    public Double getSelectivity(RelNode rel, RelMetadataQuery mq, RexNode predicate) {
        return RelMdUtil.guessSelectivity(predicate);
    }
}

