/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.org.apache.calcite.adapter.enumerable.EnumerableLimit;
import hive.org.apache.calcite.plan.volcano.RelSubset;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.SingleRel;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.Calc;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Intersect;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.Minus;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rel.core.Union;
import hive.org.apache.calcite.rel.core.Values;
import hive.org.apache.calcite.rel.metadata.BuiltInMetadata;
import hive.org.apache.calcite.rel.metadata.MetadataDef;
import hive.org.apache.calcite.rel.metadata.MetadataHandler;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMdUtil;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.NumberUtil;
import hive.org.apache.calcite.util.Util;

public class RelMdRowCount
implements MetadataHandler<BuiltInMetadata.RowCount> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.ROW_COUNT.method, new RelMdRowCount());

    @Override
    public MetadataDef<BuiltInMetadata.RowCount> getDef() {
        return BuiltInMetadata.RowCount.DEF;
    }

    public Double getRowCount(RelNode rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(RelSubset subset, RelMetadataQuery mq) {
        return mq.getRowCount(Util.first(subset.getBest(), subset.getOriginal()));
    }

    public Double getRowCount(Union rel, RelMetadataQuery mq) {
        double rowCount = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getRowCount(input);
            if (partialRowCount == null) {
                return null;
            }
            rowCount += partialRowCount.doubleValue();
        }
        return rowCount;
    }

    public Double getRowCount(Intersect rel, RelMetadataQuery mq) {
        Double rowCount = null;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getRowCount(input);
            if (rowCount != null && (partialRowCount == null || !(partialRowCount < rowCount))) continue;
            rowCount = partialRowCount;
        }
        return rowCount;
    }

    public Double getRowCount(Minus rel, RelMetadataQuery mq) {
        Double rowCount = null;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getRowCount(input);
            if (rowCount != null && (partialRowCount == null || !(partialRowCount < rowCount))) continue;
            rowCount = partialRowCount;
        }
        return rowCount;
    }

    public Double getRowCount(Filter rel, RelMetadataQuery mq) {
        return RelMdUtil.estimateFilteredRows(rel.getInput(), rel.getCondition(), mq);
    }

    public Double getRowCount(Calc rel, RelMetadataQuery mq) {
        return RelMdUtil.estimateFilteredRows(rel.getInput(), rel.getProgram(), mq);
    }

    public Double getRowCount(Project rel, RelMetadataQuery mq) {
        return mq.getRowCount(rel.getInput());
    }

    public Double getRowCount(Sort rel, RelMetadataQuery mq) {
        int limit;
        Double rowCount = mq.getRowCount(rel.getInput());
        if (rowCount == null) {
            return null;
        }
        int offset = rel.offset == null ? 0 : RexLiteral.intValue(rel.offset);
        rowCount = Math.max(rowCount - (double)offset, 0.0);
        if (rel.fetch != null && (double)(limit = RexLiteral.intValue(rel.fetch)) < rowCount) {
            return limit;
        }
        return rowCount;
    }

    public Double getRowCount(EnumerableLimit rel, RelMetadataQuery mq) {
        int limit;
        Double rowCount = mq.getRowCount(rel.getInput());
        if (rowCount == null) {
            return null;
        }
        int offset = rel.offset == null ? 0 : RexLiteral.intValue(rel.offset);
        rowCount = Math.max(rowCount - (double)offset, 0.0);
        if (rel.fetch != null && (double)(limit = RexLiteral.intValue(rel.fetch)) < rowCount) {
            return limit;
        }
        return rowCount;
    }

    public Double getRowCount(SingleRel rel, RelMetadataQuery mq) {
        return mq.getRowCount(rel.getInput());
    }

    public Double getRowCount(Join rel, RelMetadataQuery mq) {
        return RelMdUtil.getJoinRowCount(mq, rel, rel.getCondition());
    }

    public Double getRowCount(SemiJoin rel, RelMetadataQuery mq) {
        RexNode semiJoinSelectivity = RelMdUtil.makeSemiJoinSelectivityRexNode(mq, rel);
        return NumberUtil.multiply(mq.getSelectivity(rel.getLeft(), semiJoinSelectivity), mq.getRowCount(rel.getLeft()));
    }

    public Double getRowCount(Aggregate rel, RelMetadataQuery mq) {
        ImmutableBitSet groupKey = rel.getGroupSet();
        Double distinctRowCount = mq.getDistinctRowCount(rel.getInput(), groupKey, null);
        if (distinctRowCount == null) {
            distinctRowCount = mq.getRowCount(rel.getInput()) / 10.0;
        }
        distinctRowCount = distinctRowCount * (double)rel.getGroupSets().size();
        return distinctRowCount;
    }

    public Double getRowCount(TableScan rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(Values rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }
}

