/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.plan.hep.HepRelVertex;
import hive.org.apache.calcite.rel.BiRel;
import hive.org.apache.calcite.rel.RelDistribution;
import hive.org.apache.calcite.rel.RelDistributions;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.SingleRel;
import hive.org.apache.calcite.rel.core.Exchange;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.SetOp;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rel.core.Values;
import hive.org.apache.calcite.rel.metadata.BuiltInMetadata;
import hive.org.apache.calcite.rel.metadata.MetadataDef;
import hive.org.apache.calcite.rel.metadata.MetadataHandler;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexProgram;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.mapping.Mappings;
import java.util.List;

public class RelMdDistribution
implements MetadataHandler<BuiltInMetadata.Distribution> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.DISTRIBUTION.method, new RelMdDistribution());

    private RelMdDistribution() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Distribution> getDef() {
        return BuiltInMetadata.Distribution.DEF;
    }

    public RelDistribution distribution(RelMetadataQuery mq, RelNode rel) {
        return RelDistributions.SINGLETON;
    }

    public RelDistribution distribution(RelMetadataQuery mq, SingleRel rel) {
        return mq.distribution(rel.getInput());
    }

    public RelDistribution distribution(RelMetadataQuery mq, BiRel rel) {
        return mq.distribution(rel.getLeft());
    }

    public RelDistribution distribution(RelMetadataQuery mq, SetOp rel) {
        return mq.distribution(rel.getInputs().get(0));
    }

    public RelDistribution distribution(RelMetadataQuery mq, TableScan scan) {
        return RelMdDistribution.table(scan.getTable());
    }

    public RelDistribution distribution(RelMetadataQuery mq, Project project) {
        return RelMdDistribution.project(mq, project.getInput(), project.getProjects());
    }

    public RelDistribution distribution(RelMetadataQuery mq, Values values) {
        return RelMdDistribution.values(values.getRowType(), values.getTuples());
    }

    public RelDistribution distribution(RelMetadataQuery mq, Exchange exchange) {
        return RelMdDistribution.exchange(exchange.distribution);
    }

    public RelDistribution distribution(RelMetadataQuery mq, HepRelVertex rel) {
        return mq.distribution(rel.getCurrentRel());
    }

    public static RelDistribution table(RelOptTable table) {
        return table.getDistribution();
    }

    public static RelDistribution sort(RelMetadataQuery mq, RelNode input) {
        return mq.distribution(input);
    }

    public static RelDistribution filter(RelMetadataQuery mq, RelNode input) {
        return mq.distribution(input);
    }

    public static RelDistribution limit(RelMetadataQuery mq, RelNode input) {
        return mq.distribution(input);
    }

    public static RelDistribution calc(RelMetadataQuery mq, RelNode input, RexProgram program) {
        throw new AssertionError();
    }

    public static RelDistribution project(RelMetadataQuery mq, RelNode input, List<? extends RexNode> projects) {
        RelDistribution inputDistribution = mq.distribution(input);
        Mappings.TargetMapping mapping = Project.getPartialMapping(input.getRowType().getFieldCount(), projects);
        return inputDistribution.apply(mapping);
    }

    public static RelDistribution values(RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        return RelDistributions.BROADCAST_DISTRIBUTED;
    }

    public static RelDistribution exchange(RelDistribution distribution) {
        return distribution;
    }
}

