/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.base.Throwables;
import hive.com.google.common.cache.CacheBuilder;
import hive.com.google.common.cache.CacheLoader;
import hive.com.google.common.cache.LoadingCache;
import hive.com.google.common.util.concurrent.UncheckedExecutionException;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.metadata.Metadata;
import hive.org.apache.calcite.rel.metadata.MetadataFactory;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.metadata.UnboundMetadata;
import hive.org.apache.calcite.util.Pair;
import java.util.concurrent.ExecutionException;

public class MetadataFactoryImpl
implements MetadataFactory {
    public static final UnboundMetadata<Metadata> DUMMY = new UnboundMetadata<Metadata>(){

        @Override
        public Metadata bind(RelNode rel, RelMetadataQuery mq) {
            return null;
        }
    };
    private final LoadingCache<Pair<Class<RelNode>, Class<Metadata>>, UnboundMetadata<Metadata>> cache;

    public MetadataFactoryImpl(RelMetadataProvider provider) {
        this.cache = CacheBuilder.newBuilder().build(MetadataFactoryImpl.loader(provider));
    }

    static CacheLoader<Pair<Class<RelNode>, Class<Metadata>>, UnboundMetadata<Metadata>> loader(final RelMetadataProvider provider) {
        return new CacheLoader<Pair<Class<RelNode>, Class<Metadata>>, UnboundMetadata<Metadata>>(){

            @Override
            public UnboundMetadata<Metadata> load(Pair<Class<RelNode>, Class<Metadata>> key) throws Exception {
                UnboundMetadata function = provider.apply((Class)key.left, (Class)key.right);
                return function != null ? function : DUMMY;
            }
        };
    }

    @Override
    public <M extends Metadata> M query(RelNode rel, RelMetadataQuery mq, Class<M> metadataClazz) {
        try {
            Pair<Class<?>, Class<M>> key = Pair.of(rel.getClass(), metadataClazz);
            Metadata apply = this.cache.get(key).bind(rel, mq);
            return (M)((Metadata)metadataClazz.cast(apply));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }
}

