/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.base.Preconditions;
import hive.com.google.common.base.Throwables;
import hive.com.google.common.collect.ImmutableCollection;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Multimap;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.metadata.Metadata;
import hive.org.apache.calcite.rel.metadata.MetadataDef;
import hive.org.apache.calcite.rel.metadata.MetadataHandler;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.metadata.UnboundMetadata;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CachingRelMetadataProvider
implements RelMetadataProvider {
    private final Map<List, CacheEntry> cache;
    private final RelMetadataProvider underlyingProvider;
    private final RelOptPlanner planner;
    private static final Object NULL_SENTINEL = new Object(){

        public String toString() {
            return "{null}";
        }
    };

    public CachingRelMetadataProvider(RelMetadataProvider underlyingProvider, RelOptPlanner planner) {
        this.underlyingProvider = underlyingProvider;
        this.planner = planner;
        this.cache = new HashMap<List, CacheEntry>();
    }

    @Override
    public <M extends Metadata> UnboundMetadata<M> apply(Class<? extends RelNode> relClass, final Class<? extends M> metadataClass) {
        final UnboundMetadata<? extends M> function = this.underlyingProvider.apply(relClass, metadataClass);
        if (function == null) {
            return null;
        }
        return new UnboundMetadata<M>(){

            @Override
            public M bind(RelNode rel, RelMetadataQuery mq) {
                Object metadata = function.bind(rel, mq);
                return (Metadata)metadataClass.cast(Proxy.newProxyInstance(metadataClass.getClassLoader(), new Class[]{metadataClass}, (InvocationHandler)new CachingInvocationHandler((Metadata)metadata)));
            }
        };
    }

    @Override
    public <M extends Metadata> Multimap<Method, MetadataHandler<M>> handlers(MetadataDef<M> def) {
        return this.underlyingProvider.handlers(def);
    }

    private class CachingInvocationHandler
    implements InvocationHandler {
        private final Metadata metadata;

        public CachingInvocationHandler(Metadata metadata) {
            this.metadata = Preconditions.checkNotNull(metadata);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(method);
            builder.add(this.metadata.rel());
            if (args != null) {
                for (Object arg : args) {
                    builder.add(arg == null ? NULL_SENTINEL : arg);
                }
            }
            ImmutableCollection key = builder.build();
            long timestamp = CachingRelMetadataProvider.this.planner.getRelMetadataTimestamp(this.metadata.rel());
            CacheEntry entry = (CacheEntry)CachingRelMetadataProvider.this.cache.get(key);
            if (entry != null && timestamp == entry.timestamp) {
                return entry.result;
            }
            try {
                Object result = method.invoke((Object)this.metadata, args);
                if (result != null) {
                    entry = new CacheEntry();
                    entry.timestamp = timestamp;
                    entry.result = result;
                    CachingRelMetadataProvider.this.cache.put(key, entry);
                }
                return result;
            }
            catch (InvocationTargetException e) {
                Throwables.propagateIfPossible(e.getCause());
                throw e;
            }
        }
    }

    private static class CacheEntry {
        long timestamp;
        Object result;

        private CacheEntry() {
        }
    }
}

