/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.core;

import hive.com.google.common.base.Function;
import hive.com.google.common.base.Predicate;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.AbstractRelNode;
import hive.org.apache.calcite.rel.RelInput;
import hive.org.apache.calcite.rel.RelWriter;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.sql.SqlExplainLevel;
import hive.org.apache.calcite.sql.type.SqlTypeUtil;
import hive.org.apache.calcite.util.Pair;
import java.util.List;

public abstract class Values
extends AbstractRelNode {
    private static final Function<ImmutableList<RexLiteral>, Object> F = new Function<ImmutableList<RexLiteral>, Object>(){

        @Override
        public Object apply(ImmutableList<RexLiteral> tuple) {
            String s = tuple.toString();
            assert (s.startsWith("["));
            assert (s.endsWith("]"));
            return "{ " + s.substring(1, s.length() - 1) + " }";
        }
    };
    public static final Predicate<? super Values> IS_EMPTY = new Predicate<Values>(){

        @Override
        public boolean apply(Values values) {
            return values.getTuples().isEmpty();
        }
    };
    public final ImmutableList<ImmutableList<RexLiteral>> tuples;

    protected Values(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traits) {
        super(cluster, traits);
        this.rowType = rowType;
        this.tuples = tuples;
        assert (this.assertRowType());
    }

    public Values(RelInput input) {
        this(input.getCluster(), input.getRowType("type"), input.getTuples("tuples"), input.getTraitSet());
    }

    public ImmutableList<ImmutableList<RexLiteral>> getTuples(RelInput input) {
        return input.getTuples("tuples");
    }

    public ImmutableList<ImmutableList<RexLiteral>> getTuples() {
        return this.tuples;
    }

    private boolean assertRowType() {
        for (List list : this.tuples) {
            assert (list.size() == this.rowType.getFieldCount());
            for (Pair pair : Pair.zip(list, this.rowType.getFieldList())) {
                RexLiteral literal = (RexLiteral)pair.left;
                RelDataType fieldType = ((RelDataTypeField)pair.right).getType();
                if (!RexLiteral.isNullLiteral(literal)) assert (SqlTypeUtil.canAssignFrom(fieldType, literal.getType())) : "to " + fieldType + " from " + literal;
            }
        }
        return true;
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = mq.getRowCount(this);
        double dCpu = 1.0;
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return this.tuples.size();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("type", this.rowType, pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("type", this.rowType.getFieldList(), pw.nest()).itemIf("tuples", Lists.transform(this.tuples, F), !pw.nest()).itemIf("tuples", this.tuples, pw.nest());
    }
}

