/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.core;

import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.AbstractRelNode;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelInput;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelShuttle;
import hive.org.apache.calcite.rel.RelWriter;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.ImmutableIntList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class TableScan
extends AbstractRelNode {
    protected final RelOptTable table;

    protected TableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table) {
        super(cluster, traitSet);
        this.table = table;
        if (table.getRelOptSchema() != null) {
            cluster.getPlanner().registerSchema(table.getRelOptSchema());
        }
    }

    protected TableScan(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getTable("table"));
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return this.table.getRowCount();
    }

    @Override
    public RelOptTable getTable() {
        return this.table;
    }

    @Override
    public List<RelCollation> getCollationList() {
        return this.table.getCollationList();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = this.table.getRowCount();
        double dCpu = dRows + 1.0;
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.table.getRowType();
    }

    public static ImmutableIntList identity(RelOptTable table) {
        return ImmutableIntList.identity(table.getRowType().getFieldCount());
    }

    public ImmutableIntList identity() {
        return TableScan.identity(this.table);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("table", this.table.getQualifiedName());
    }

    public RelNode project(ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields, RelFactories.ProjectFactory projectFactory) {
        int fieldCount = this.getRowType().getFieldCount();
        if (fieldsUsed.equals(ImmutableBitSet.range(fieldCount)) && extraFields.isEmpty()) {
            return this;
        }
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        ArrayList<String> nameList = new ArrayList<String>();
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        List<RelDataTypeField> fields = this.getRowType().getFieldList();
        Iterator<Object> iterator = fieldsUsed.iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            RelDataTypeField field = fields.get(i);
            exprList.add(rexBuilder.makeInputRef(this, i));
            nameList.add(field.getName());
        }
        for (RelDataTypeField extraField : extraFields) {
            exprList.add(rexBuilder.ensureType(extraField.getType(), rexBuilder.constantNull(), true));
            nameList.add(extraField.getName());
        }
        return projectFactory.createProject(this, exprList, nameList);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }
}

