/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.core;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.Contexts;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.AggregateCall;
import hive.org.apache.calcite.rel.core.JoinInfo;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.logical.LogicalAggregate;
import hive.org.apache.calcite.rel.logical.LogicalFilter;
import hive.org.apache.calcite.rel.logical.LogicalIntersect;
import hive.org.apache.calcite.rel.logical.LogicalJoin;
import hive.org.apache.calcite.rel.logical.LogicalMinus;
import hive.org.apache.calcite.rel.logical.LogicalProject;
import hive.org.apache.calcite.rel.logical.LogicalSort;
import hive.org.apache.calcite.rel.logical.LogicalTableScan;
import hive.org.apache.calcite.rel.logical.LogicalUnion;
import hive.org.apache.calcite.rel.logical.LogicalValues;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.tools.RelBuilder;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.List;
import java.util.Set;

public class RelFactories {
    public static final ProjectFactory DEFAULT_PROJECT_FACTORY = new ProjectFactoryImpl();
    public static final FilterFactory DEFAULT_FILTER_FACTORY = new FilterFactoryImpl();
    public static final JoinFactory DEFAULT_JOIN_FACTORY = new JoinFactoryImpl();
    public static final SemiJoinFactory DEFAULT_SEMI_JOIN_FACTORY = new SemiJoinFactoryImpl();
    public static final SortFactory DEFAULT_SORT_FACTORY = new SortFactoryImpl();
    public static final AggregateFactory DEFAULT_AGGREGATE_FACTORY = new AggregateFactoryImpl();
    public static final SetOpFactory DEFAULT_SET_OP_FACTORY = new SetOpFactoryImpl();
    public static final ValuesFactory DEFAULT_VALUES_FACTORY = new ValuesFactoryImpl();
    public static final TableScanFactory DEFAULT_TABLE_SCAN_FACTORY = new TableScanFactoryImpl();
    public static final RelBuilder.ProtoRelBuilder DEFAULT_PROTO = RelBuilder.proto(Contexts.of(DEFAULT_PROJECT_FACTORY, DEFAULT_FILTER_FACTORY, DEFAULT_JOIN_FACTORY, DEFAULT_SEMI_JOIN_FACTORY, DEFAULT_SORT_FACTORY, DEFAULT_AGGREGATE_FACTORY, DEFAULT_SET_OP_FACTORY, DEFAULT_VALUES_FACTORY, DEFAULT_TABLE_SCAN_FACTORY));

    private RelFactories() {
    }

    private static class TableScanFactoryImpl
    implements TableScanFactory {
        private TableScanFactoryImpl() {
        }

        @Override
        public RelNode createScan(RelOptCluster cluster, RelOptTable table) {
            return LogicalTableScan.create(cluster, table);
        }
    }

    public static interface TableScanFactory {
        public RelNode createScan(RelOptCluster var1, RelOptTable var2);
    }

    private static class ValuesFactoryImpl
    implements ValuesFactory {
        private ValuesFactoryImpl() {
        }

        @Override
        public RelNode createValues(RelOptCluster cluster, RelDataType rowType, List<ImmutableList<RexLiteral>> tuples) {
            return LogicalValues.create(cluster, rowType, ImmutableList.copyOf(tuples));
        }
    }

    public static interface ValuesFactory {
        public RelNode createValues(RelOptCluster var1, RelDataType var2, List<ImmutableList<RexLiteral>> var3);
    }

    private static class SemiJoinFactoryImpl
    implements SemiJoinFactory {
        private SemiJoinFactoryImpl() {
        }

        @Override
        public RelNode createSemiJoin(RelNode left, RelNode right, RexNode condition) {
            JoinInfo joinInfo = JoinInfo.of(left, right, condition);
            return SemiJoin.create(left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
        }
    }

    public static interface SemiJoinFactory {
        public RelNode createSemiJoin(RelNode var1, RelNode var2, RexNode var3);
    }

    private static class JoinFactoryImpl
    implements JoinFactory {
        private JoinFactoryImpl() {
        }

        @Override
        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone) {
            return LogicalJoin.create(left, right, condition, joinType, variablesStopped, semiJoinDone, ImmutableList.of());
        }
    }

    public static interface JoinFactory {
        public RelNode createJoin(RelNode var1, RelNode var2, RexNode var3, JoinRelType var4, Set<String> var5, boolean var6);
    }

    private static class FilterFactoryImpl
    implements FilterFactory {
        private FilterFactoryImpl() {
        }

        @Override
        public RelNode createFilter(RelNode input, RexNode condition) {
            return LogicalFilter.create(input, condition);
        }
    }

    public static interface FilterFactory {
        public RelNode createFilter(RelNode var1, RexNode var2);
    }

    private static class AggregateFactoryImpl
    implements AggregateFactory {
        private AggregateFactoryImpl() {
        }

        @Override
        public RelNode createAggregate(RelNode input, boolean indicator, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            return LogicalAggregate.create(input, indicator, groupSet, groupSets, aggCalls);
        }
    }

    public static interface AggregateFactory {
        public RelNode createAggregate(RelNode var1, boolean var2, ImmutableBitSet var3, ImmutableList<ImmutableBitSet> var4, List<AggregateCall> var5);
    }

    private static class SetOpFactoryImpl
    implements SetOpFactory {
        private SetOpFactoryImpl() {
        }

        @Override
        public RelNode createSetOp(SqlKind kind, List<RelNode> inputs, boolean all) {
            switch (kind) {
                case UNION: {
                    return LogicalUnion.create(inputs, all);
                }
                case EXCEPT: {
                    return LogicalMinus.create(inputs, all);
                }
                case INTERSECT: {
                    return LogicalIntersect.create(inputs, all);
                }
            }
            throw new AssertionError((Object)("not a set op: " + (Object)((Object)kind)));
        }
    }

    public static interface SetOpFactory {
        public RelNode createSetOp(SqlKind var1, List<RelNode> var2, boolean var3);
    }

    private static class SortFactoryImpl
    implements SortFactory {
        private SortFactoryImpl() {
        }

        @Override
        public RelNode createSort(RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
            return LogicalSort.create(input, collation, offset, fetch);
        }

        @Override
        @Deprecated
        public RelNode createSort(RelTraitSet traits, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
            return this.createSort(input, collation, offset, fetch);
        }
    }

    public static interface SortFactory {
        public RelNode createSort(RelNode var1, RelCollation var2, RexNode var3, RexNode var4);

        @Deprecated
        public RelNode createSort(RelTraitSet var1, RelNode var2, RelCollation var3, RexNode var4, RexNode var5);
    }

    private static class ProjectFactoryImpl
    implements ProjectFactory {
        private ProjectFactoryImpl() {
        }

        @Override
        public RelNode createProject(RelNode input, List<? extends RexNode> childExprs, List<String> fieldNames) {
            return LogicalProject.create(input, childExprs, fieldNames);
        }
    }

    public static interface ProjectFactory {
        public RelNode createProject(RelNode var1, List<? extends RexNode> var2, List<String> var3);
    }
}

