/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.core;

import hive.com.google.common.base.Preconditions;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.runtime.FlatLists;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.ImmutableIntList;
import hive.org.apache.calcite.util.mapping.IntPair;
import java.util.ArrayList;
import java.util.List;

public abstract class JoinInfo {
    public final ImmutableIntList leftKeys;
    public final ImmutableIntList rightKeys;

    protected JoinInfo(ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        this.leftKeys = Preconditions.checkNotNull(leftKeys);
        this.rightKeys = Preconditions.checkNotNull(rightKeys);
        assert (leftKeys.size() == rightKeys.size());
    }

    public static JoinInfo of(RelNode left, RelNode right, RexNode condition) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        ArrayList<Boolean> filterNulls = new ArrayList<Boolean>();
        RexNode remaining = RelOptUtil.splitJoinCondition(left, right, condition, leftKeys, rightKeys, filterNulls);
        if (remaining.isAlwaysTrue()) {
            return new EquiJoinInfo(ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys));
        }
        return new NonEquiJoinInfo(ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys), remaining);
    }

    public static JoinInfo of(ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        return new EquiJoinInfo(leftKeys, rightKeys);
    }

    public abstract boolean isEqui();

    public List<IntPair> pairs() {
        return IntPair.zip(this.leftKeys, this.rightKeys);
    }

    public ImmutableBitSet leftSet() {
        return ImmutableBitSet.of(this.leftKeys);
    }

    public ImmutableBitSet rightSet() {
        return ImmutableBitSet.of(this.rightKeys);
    }

    public abstract RexNode getRemaining(RexBuilder var1);

    public RexNode getEquiCondition(RelNode left, RelNode right, RexBuilder rexBuilder) {
        return RelOptUtil.createEquiJoinCondition(left, this.leftKeys, right, this.rightKeys, rexBuilder);
    }

    public List<ImmutableIntList> keys() {
        return FlatLists.of(this.leftKeys, this.rightKeys);
    }

    private static class NonEquiJoinInfo
    extends JoinInfo {
        public final RexNode remaining;

        protected NonEquiJoinInfo(ImmutableIntList leftKeys, ImmutableIntList rightKeys, RexNode remaining) {
            super(leftKeys, rightKeys);
            this.remaining = Preconditions.checkNotNull(remaining);
            assert (!remaining.isAlwaysTrue());
        }

        @Override
        public boolean isEqui() {
            return false;
        }

        @Override
        public RexNode getRemaining(RexBuilder rexBuilder) {
            return this.remaining;
        }
    }

    private static class EquiJoinInfo
    extends JoinInfo {
        protected EquiJoinInfo(ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
            super(leftKeys, rightKeys);
        }

        @Override
        public boolean isEqui() {
            return true;
        }

        @Override
        public RexNode getRemaining(RexBuilder rexBuilder) {
            return rexBuilder.makeLiteral(true);
        }
    }
}

