/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.core;

import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelInput;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.SetOp;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.List;

public abstract class Intersect
extends SetOp {
    public Intersect(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        super(cluster, traits, inputs, SqlKind.INTERSECT, all);
    }

    protected Intersect(RelInput input) {
        super(input);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double dRows = Double.MAX_VALUE;
        for (RelNode input : this.inputs) {
            dRows = Math.min(dRows, mq.getRowCount(input));
        }
        return dRows *= 0.25;
    }

    @Override
    public boolean isKey(ImmutableBitSet columns) {
        for (RelNode input : this.inputs) {
            if (!input.isKey(columns)) continue;
            return true;
        }
        return super.isKey(columns);
    }
}

