/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.core;

import hive.com.google.common.collect.ImmutableSet;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.BiRel;
import hive.org.apache.calcite.rel.RelInput;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelWriter;
import hive.org.apache.calcite.rel.core.CorrelationId;
import hive.org.apache.calcite.rel.logical.LogicalJoin;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SemiJoinType;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.List;
import java.util.Set;

public abstract class Correlate
extends BiRel {
    protected final CorrelationId correlationId;
    protected final ImmutableBitSet requiredColumns;
    protected final SemiJoinType joinType;

    protected Correlate(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, SemiJoinType joinType) {
        super(cluster, traits, left, right);
        this.joinType = joinType;
        this.correlationId = correlationId;
        this.requiredColumns = requiredColumns;
    }

    public Correlate(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInputs().get(0), input.getInputs().get(1), new CorrelationId((Integer)input.get("correlationId")), input.getBitSet("requiredColumns"), input.getEnum("joinType", SemiJoinType.class));
    }

    @Override
    public Correlate copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return this.copy(traitSet, inputs.get(0), inputs.get(1), this.correlationId, this.requiredColumns, this.joinType);
    }

    public abstract Correlate copy(RelTraitSet var1, RelNode var2, RelNode var3, CorrelationId var4, ImmutableBitSet var5, SemiJoinType var6);

    public SemiJoinType getJoinType() {
        return this.joinType;
    }

    @Override
    protected RelDataType deriveRowType() {
        switch (this.joinType) {
            case LEFT: 
            case INNER: {
                LogicalJoin join = LogicalJoin.create(this.left, this.right, this.getCluster().getRexBuilder().makeLiteral(true), this.joinType.toJoinType(), ImmutableSet.of());
                return join.deriveRowType();
            }
            case ANTI: 
            case SEMI: {
                return this.left.getRowType();
            }
        }
        throw new IllegalStateException("Unknown join type " + this.joinType);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("correlation", this.correlationId).item("joinType", this.joinType).item("requiredColumns", this.requiredColumns.toString());
    }

    public CorrelationId getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public String getCorrelVariable() {
        return this.correlationId.getName();
    }

    public ImmutableBitSet getRequiredColumns() {
        return this.requiredColumns;
    }

    @Override
    public Set<String> getVariablesStopped() {
        return ImmutableSet.of(this.correlationId.getName());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        double rightRowCount = this.right.estimateRowCount(mq);
        double leftRowCount = this.left.estimateRowCount(mq);
        if (Double.isInfinite(leftRowCount) || Double.isInfinite(rightRowCount)) {
            return planner.getCostFactory().makeInfiniteCost();
        }
        Double restartCount = mq.getRowCount(this.getLeft());
        RelOptCost rightCost = planner.getCost(this.getRight(), mq);
        RelOptCost rescanCost = rightCost.multiplyBy(Math.max(1.0, restartCount - 1.0));
        return planner.getCostFactory().makeCost(rowCount + leftRowCount, 0.0, 0.0).plus(rescanCost);
    }
}

