/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.plan.volcano;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptListener;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelTraitPropagationVisitor;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.plan.volcano.RelSubset;
import hive.org.apache.calcite.plan.volcano.VolcanoPlanner;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class VolcanoRuleCall
extends RelOptRuleCall {
    protected final VolcanoPlanner volcanoPlanner;
    private List<RelNode> generatedRelList;

    protected VolcanoRuleCall(VolcanoPlanner planner, RelOptRuleOperand operand, RelNode[] rels) {
        super(planner, operand, rels, Collections.emptyMap());
        this.volcanoPlanner = planner;
    }

    VolcanoRuleCall(VolcanoPlanner planner, RelOptRuleOperand operand) {
        this(planner, operand, new RelNode[operand.getRule().operands.size()]);
    }

    @Override
    public void transformTo(RelNode rel, Map<RelNode, RelNode> equiv) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Transform to: rel#" + rel.getId() + " via " + this.getRule() + (equiv.isEmpty() ? "" : " with equivalences " + equiv));
            if (this.generatedRelList != null) {
                this.generatedRelList.add(rel);
            }
        }
        try {
            Object event;
            RelTraitSet rels0Traits = this.rels[0].getTraitSet();
            new RelTraitPropagationVisitor(this.getPlanner(), rels0Traits).go(rel);
            if (LOGGER.isLoggable(Level.FINEST)) {
                String relDesc = "rel#" + rel.getId() + ":" + rel.getRelTypeName();
                LOGGER.finest("call#" + this.id + ": Rule " + this.getRule() + " arguments " + Arrays.toString(this.rels) + " created " + relDesc);
            }
            if (this.volcanoPlanner.listener != null) {
                event = new RelOptListener.RuleProductionEvent(this.volcanoPlanner, rel, this, true);
                this.volcanoPlanner.listener.ruleProductionSucceeded((RelOptListener.RuleProductionEvent)event);
            }
            for (Map.Entry<RelNode, RelNode> entry : equiv.entrySet()) {
                this.volcanoPlanner.ensureRegistered(entry.getKey(), entry.getValue(), this);
            }
            this.volcanoPlanner.ensureRegistered(rel, this.rels[0], this);
            if (this.volcanoPlanner.listener != null) {
                event = new RelOptListener.RuleProductionEvent(this.volcanoPlanner, rel, this, false);
                this.volcanoPlanner.listener.ruleProductionSucceeded((RelOptListener.RuleProductionEvent)event);
            }
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "Error occurred while applying rule " + this.getRule());
        }
    }

    protected void onMatch() {
        assert (this.getRule().matches(this));
        this.volcanoPlanner.checkCancel();
        try {
            if (this.volcanoPlanner.isRuleExcluded(this.getRule())) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Rule [" + this.getRule() + "] not fired due to exclusion filter");
                }
                return;
            }
            for (int i = 0; i < this.rels.length; ++i) {
                RelNode rel = this.rels[i];
                RelSubset subset = this.volcanoPlanner.getSubset(rel);
                if (subset == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Rule [" + this.getRule() + "] not fired because operand #" + i + " (" + rel + ") has no subset");
                    }
                    return;
                }
                if (subset.set.equivalentSet != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Rule [" + this.getRule() + "] not fired because operand #" + i + " (" + rel + ") belongs to obsolete set");
                    }
                    return;
                }
                Double importance = this.volcanoPlanner.relImportances.get(rel);
                if (importance == null || importance != 0.0) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Rule [" + this.getRule() + "] not fired because operand #" + i + " (" + rel + ") has importance=0");
                }
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("call#" + this.id + ": Apply rule [" + this.getRule() + "] to " + Arrays.toString(this.rels));
            }
            if (this.volcanoPlanner.listener != null) {
                RelOptListener.RuleAttemptedEvent event = new RelOptListener.RuleAttemptedEvent(this.volcanoPlanner, this.rels[0], this, true);
                this.volcanoPlanner.listener.ruleAttempted(event);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                this.generatedRelList = new ArrayList<RelNode>();
            }
            this.getRule().onMatch(this);
            if (LOGGER.isLoggable(Level.FINE)) {
                if (this.generatedRelList.isEmpty()) {
                    LOGGER.fine("call#" + this.id + " generated 0 successors.");
                } else {
                    LOGGER.fine("call#" + this.id + " generated " + this.generatedRelList.size() + " successors: " + this.generatedRelList);
                }
                this.generatedRelList = null;
            }
            if (this.volcanoPlanner.listener != null) {
                RelOptListener.RuleAttemptedEvent event = new RelOptListener.RuleAttemptedEvent(this.volcanoPlanner, this.rels[0], this, false);
                this.volcanoPlanner.listener.ruleAttempted(event);
            }
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "Error while applying rule " + this.getRule() + ", args " + Arrays.toString(this.rels));
        }
    }

    void match(RelNode rel) {
        assert (this.getOperand0().matches(rel));
        boolean solve = false;
        int operandOrdinal = this.getOperand0().solveOrder[0];
        this.rels[operandOrdinal] = rel;
        this.matchRecurse(1);
    }

    private void matchRecurse(int solve) {
        if (solve == this.getRule().operands.size()) {
            if (this.getRule().matches(this)) {
                this.onMatch();
            }
        } else {
            Collection<RelNode> successors;
            int operandOrdinal = this.getOperand0().solveOrder[solve];
            int previousOperandOrdinal = this.getOperand0().solveOrder[solve - 1];
            boolean ascending = operandOrdinal < previousOperandOrdinal;
            RelOptRuleOperand previousOperand = this.getRule().operands.get(previousOperandOrdinal);
            RelOptRuleOperand operand = this.getRule().operands.get(operandOrdinal);
            if (ascending) {
                assert (previousOperand.getParent() == operand);
                RelNode childRel = this.rels[previousOperandOrdinal];
                RelSubset subset = this.volcanoPlanner.getSubset(childRel);
                successors = subset.getParentRels();
            } else {
                int parentOrdinal = operand.getParent().ordinalInRule;
                RelNode parentRel = this.rels[parentOrdinal];
                List<RelNode> inputs = parentRel.getInputs();
                if (operand.ordinalInParent < inputs.size()) {
                    RelSubset subset = (RelSubset)inputs.get(operand.ordinalInParent);
                    successors = operand.getMatchedClass() == RelSubset.class ? subset.set.subsets : subset.getRelList();
                } else {
                    successors = ImmutableList.of();
                }
            }
            for (RelNode rel : successors) {
                if (!operand.matches(rel)) continue;
                if (ascending) {
                    RelSubset input = (RelSubset)rel.getInput(previousOperand.ordinalInParent);
                    List<RelNode> inputRels = input.set.getRelsFromAllSubsets();
                    if (!inputRels.contains(this.rels[previousOperandOrdinal])) continue;
                }
                this.rels[operandOrdinal] = rel;
                this.matchRecurse(solve + 1);
            }
        }
    }
}

