/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.plan.hep;

import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.AbstractRelNode;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelWriter;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.Util;
import java.util.List;

public class HepRelVertex
extends AbstractRelNode {
    private RelNode currentRel;

    HepRelVertex(RelNode rel) {
        super(rel.getCluster(), rel.getTraitSet());
        this.currentRel = rel;
    }

    @Override
    public void explain(RelWriter pw) {
        this.currentRel.explain(pw);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.equals(this.traitSet));
        assert (inputs.equals(this.getInputs()));
        return this;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        throw Util.newInternal("should never get here");
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return mq.getRowCount(this.currentRel);
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.currentRel.getRowType();
    }

    @Override
    public boolean isDistinct() {
        return this.currentRel.isDistinct();
    }

    @Override
    public boolean isKey(ImmutableBitSet columns) {
        return this.currentRel.isKey(columns);
    }

    @Override
    protected String computeDigest() {
        return "HepRelVertex(" + this.currentRel + ")";
    }

    void replaceRel(RelNode newRel) {
        this.currentRel = newRel;
    }

    public RelNode getCurrentRel() {
        return this.currentRel;
    }
}

