/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.plan;

import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.prepare.CalcitePrepareImpl;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelShuttleImpl;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rel.logical.LogicalJoin;
import hive.org.apache.calcite.rel.logical.LogicalTableScan;
import hive.org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import hive.org.apache.calcite.rel.rules.AggregateFilterTransposeRule;
import hive.org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import hive.org.apache.calcite.rel.rules.FilterJoinRule;
import hive.org.apache.calcite.rel.rules.JoinProjectTransposeRule;
import hive.org.apache.calcite.rel.rules.ProjectFilterTransposeRule;
import hive.org.apache.calcite.rel.rules.ProjectMergeRule;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.schema.Table;
import hive.org.apache.calcite.schema.impl.StarTable;
import hive.org.apache.calcite.sql.SqlExplainLevel;
import hive.org.apache.calcite.tools.Program;
import hive.org.apache.calcite.tools.Programs;
import hive.org.apache.calcite.util.Util;
import hive.org.apache.calcite.util.mapping.Mappings;
import java.util.ArrayList;

public class RelOptMaterialization {
    public final RelNode tableRel;
    public final RelOptTable starRelOptTable;
    public final StarTable starTable;
    public final RelOptTable table;
    public final RelNode queryRel;

    public RelOptMaterialization(RelNode tableRel, RelNode queryRel, RelOptTable starRelOptTable) {
        this.tableRel = RelOptUtil.createCastRel(tableRel, queryRel.getRowType(), false);
        this.starRelOptTable = starRelOptTable;
        if (starRelOptTable == null) {
            this.starTable = null;
        } else {
            this.starTable = starRelOptTable.unwrap(StarTable.class);
            assert (this.starTable != null);
        }
        this.table = tableRel.getTable();
        this.queryRel = queryRel;
    }

    public static RelNode tryUseStar(RelNode rel, final RelOptTable starRelOptTable) {
        final StarTable starTable = starRelOptTable.unwrap(StarTable.class);
        assert (starTable != null);
        RelNode rel2 = rel.accept(new RelShuttleImpl(){

            @Override
            public RelNode visit(TableScan scan) {
                RelOptTable relOptTable = scan.getTable();
                Table table = relOptTable.unwrap(Table.class);
                if (table.equals(starTable.tables.get(0))) {
                    Mappings.TargetMapping mapping = Mappings.createShiftMapping(starRelOptTable.getRowType().getFieldCount(), 0, 0, relOptTable.getRowType().getFieldCount());
                    RelOptCluster cluster = scan.getCluster();
                    RelNode scan2 = starRelOptTable.toRel(RelOptUtil.getContext(cluster));
                    return RelOptUtil.createProject(scan2, Mappings.asList(mapping.inverse()));
                }
                return scan;
            }

            @Override
            public RelNode visit(LogicalJoin join) {
                RelNode rel;
                while ((rel = super.visit(join)) != join && rel instanceof LogicalJoin) {
                    ProjectFilterTable right;
                    join = (LogicalJoin)rel;
                    ProjectFilterTable left = ProjectFilterTable.of(join.getLeft());
                    if (left == null || (right = ProjectFilterTable.of(join.getRight())) == null) continue;
                    try {
                        this.match(left, right, join.getCluster());
                    }
                    catch (Util.FoundOne e) {
                        return (RelNode)e.getNode();
                    }
                }
                return rel;
            }

            private void match(ProjectFilterTable left, ProjectFilterTable right, RelOptCluster cluster) {
                Mappings.TargetMapping leftMapping = left.mapping();
                Mappings.TargetMapping rightMapping = right.mapping();
                RelOptTable leftRelOptTable = left.getTable();
                Table leftTable = leftRelOptTable.unwrap(Table.class);
                int leftCount = leftRelOptTable.getRowType().getFieldCount();
                RelOptTable rightRelOptTable = right.getTable();
                Table rightTable = rightRelOptTable.unwrap(Table.class);
                if (leftTable instanceof StarTable && ((StarTable)leftTable).tables.contains(rightTable)) {
                    int offset = ((StarTable)leftTable).columnOffset(rightTable);
                    Mappings.TargetMapping mapping = Mappings.merge(leftMapping, Mappings.offsetTarget(Mappings.offsetSource(rightMapping, offset), leftMapping.getTargetCount()));
                    RelNode project = RelOptUtil.createProject((RelNode)LogicalTableScan.create(cluster, leftRelOptTable), Mappings.asList(mapping.inverse()));
                    ArrayList<RexNode> conditions = Lists.newArrayList();
                    if (left.condition != null) {
                        conditions.add(left.condition);
                    }
                    if (right.condition != null) {
                        conditions.add(RexUtil.apply(mapping, RexUtil.shift(right.condition, offset)));
                    }
                    RelNode filter = RelOptUtil.createFilter(project, conditions);
                    throw new Util.FoundOne(filter);
                }
                if (rightTable instanceof StarTable && ((StarTable)rightTable).tables.contains(leftTable)) {
                    int offset = ((StarTable)rightTable).columnOffset(leftTable);
                    Mappings.TargetMapping mapping = Mappings.merge(Mappings.offsetSource(leftMapping, offset), Mappings.offsetTarget(rightMapping, leftCount));
                    RelNode project = RelOptUtil.createProject((RelNode)LogicalTableScan.create(cluster, rightRelOptTable), Mappings.asList(mapping.inverse()));
                    ArrayList<RexNode> conditions = Lists.newArrayList();
                    if (left.condition != null) {
                        conditions.add(RexUtil.apply(mapping, RexUtil.shift(left.condition, offset)));
                    }
                    if (right.condition != null) {
                        conditions.add(RexUtil.apply(mapping, right.condition));
                    }
                    RelNode filter = RelOptUtil.createFilter(project, conditions);
                    throw new Util.FoundOne(filter);
                }
            }
        });
        if (rel2 == rel) {
            return null;
        }
        Program program = Programs.hep(ImmutableList.of(ProjectFilterTransposeRule.INSTANCE, AggregateProjectMergeRule.INSTANCE, AggregateFilterTransposeRule.INSTANCE), false, DefaultRelMetadataProvider.INSTANCE);
        return program.run(null, rel2, null);
    }

    public static RelNode toLeafJoinForm(RelNode rel) {
        Program program = Programs.hep(ImmutableList.of(JoinProjectTransposeRule.RIGHT_PROJECT, JoinProjectTransposeRule.LEFT_PROJECT, FilterJoinRule.FilterIntoJoinRule.FILTER_ON_JOIN, ProjectMergeRule.INSTANCE), false, DefaultRelMetadataProvider.INSTANCE);
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println(RelOptUtil.dumpPlan("before", rel, false, SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        RelNode rel2 = program.run(null, rel, null);
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println(RelOptUtil.dumpPlan("after", rel2, false, SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        return rel2;
    }

    private static class ProjectFilterTable {
        final RexNode condition;
        final Mappings.TargetMapping mapping;
        final TableScan scan;

        private ProjectFilterTable(RexNode condition, Mappings.TargetMapping mapping, TableScan scan) {
            this.condition = condition;
            this.mapping = mapping;
            this.scan = Preconditions.checkNotNull(scan);
        }

        static ProjectFilterTable of(RelNode node) {
            if (node instanceof Filter) {
                Filter filter = (Filter)node;
                return ProjectFilterTable.of2(filter.getCondition(), filter.getInput());
            }
            return ProjectFilterTable.of2(null, node);
        }

        private static ProjectFilterTable of2(RexNode condition, RelNode node) {
            if (node instanceof Project) {
                Project project = (Project)node;
                return ProjectFilterTable.of3(condition, project.getMapping(), project.getInput());
            }
            return ProjectFilterTable.of3(condition, null, node);
        }

        private static ProjectFilterTable of3(RexNode condition, Mappings.TargetMapping mapping, RelNode node) {
            if (node instanceof TableScan) {
                return new ProjectFilterTable(condition, mapping, (TableScan)node);
            }
            return null;
        }

        public Mappings.TargetMapping mapping() {
            return this.mapping != null ? this.mapping : Mappings.createIdentity(this.scan.getRowType().getFieldCount());
        }

        public RelOptTable getTable() {
            return this.scan.getTable();
        }
    }
}

