/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.materialize;

import hive.com.google.common.base.Function;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.ImmutableMap;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.Sets;
import hive.org.apache.calcite.DataContext;
import hive.org.apache.calcite.adapter.clone.CloneSchema;
import hive.org.apache.calcite.avatica.ColumnMetaData;
import hive.org.apache.calcite.config.CalciteConnectionProperty;
import hive.org.apache.calcite.jdbc.CalciteConnection;
import hive.org.apache.calcite.jdbc.CalciteMetaImpl;
import hive.org.apache.calcite.jdbc.CalcitePrepare;
import hive.org.apache.calcite.jdbc.CalciteSchema;
import hive.org.apache.calcite.linq4j.AbstractQueryable;
import hive.org.apache.calcite.linq4j.Enumerator;
import hive.org.apache.calcite.linq4j.QueryProvider;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.materialize.Lattice;
import hive.org.apache.calcite.materialize.MaterializationActor;
import hive.org.apache.calcite.materialize.MaterializationKey;
import hive.org.apache.calcite.materialize.TileKey;
import hive.org.apache.calcite.prepare.Prepare;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeImpl;
import hive.org.apache.calcite.runtime.Hook;
import hive.org.apache.calcite.schema.Schemas;
import hive.org.apache.calcite.schema.Table;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Util;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class MaterializationService {
    private static final MaterializationService INSTANCE = new MaterializationService();
    private static final ThreadLocal<MaterializationService> THREAD_INSTANCE = new ThreadLocal<MaterializationService>(){

        @Override
        protected MaterializationService initialValue() {
            return new MaterializationService();
        }
    };
    private static final Comparator<Pair<CalciteSchema.TableEntry, TileKey>> C = new Comparator<Pair<CalciteSchema.TableEntry, TileKey>>(){

        @Override
        public int compare(Pair<CalciteSchema.TableEntry, TileKey> o0, Pair<CalciteSchema.TableEntry, TileKey> o1) {
            Table t0 = ((CalciteSchema.TableEntry)o0.left).getTable();
            Table t1 = ((CalciteSchema.TableEntry)o1.left).getTable();
            int c = Double.compare(t0.getStatistic().getRowCount(), t1.getStatistic().getRowCount());
            if (c != 0) {
                return c;
            }
            return ((CalciteSchema.TableEntry)o0.left).name.compareTo(((CalciteSchema.TableEntry)o1.left).name);
        }
    };
    private final MaterializationActor actor = new MaterializationActor();
    private final DefaultTableFactory tableFactory = new DefaultTableFactory();

    private MaterializationService() {
    }

    public MaterializationKey defineMaterialization(CalciteSchema schema, TileKey tileKey, String viewSql, List<String> viewSchemaPath, String suggestedTableName, boolean create, boolean existing) {
        return this.defineMaterialization(schema, tileKey, viewSql, viewSchemaPath, suggestedTableName, this.tableFactory, create, existing);
    }

    public MaterializationKey defineMaterialization(CalciteSchema schema, TileKey tileKey, String viewSql, List<String> viewSchemaPath, String suggestedTableName, TableFactory tableFactory, boolean create, boolean existing) {
        MaterializationActor.QueryKey queryKey = new MaterializationActor.QueryKey(viewSql, schema, viewSchemaPath);
        MaterializationKey existingKey = this.actor.keyBySql.get(queryKey);
        if (existingKey != null) {
            return existingKey;
        }
        if (!create) {
            return null;
        }
        CalciteConnection connection = CalciteMetaImpl.connect(schema.root(), null);
        CalciteSchema.TableEntry tableEntry = existing ? schema.getTable(suggestedTableName, true) : null;
        if (tableEntry == null) {
            tableEntry = schema.getTableBySql(viewSql);
        }
        RelDataType rowType = null;
        if (tableEntry == null) {
            Table table = tableFactory.createTable(schema, viewSql, viewSchemaPath);
            String tableName = Schemas.uniqueTableName(schema, Util.first(suggestedTableName, "m"));
            tableEntry = schema.add(tableName, table, ImmutableList.of(viewSql));
            Hook.CREATE_MATERIALIZATION.run(tableName);
            rowType = table.getRowType(connection.getTypeFactory());
        }
        if (rowType == null) {
            CalcitePrepare.ParseResult parse = Schemas.parse(connection, schema, viewSchemaPath, viewSql);
            rowType = parse.rowType;
        }
        MaterializationKey key = new MaterializationKey();
        MaterializationActor.Materialization materialization = new MaterializationActor.Materialization(key, schema.root(), tableEntry, viewSql, rowType);
        this.actor.keyMap.put(materialization.key, materialization);
        this.actor.keyBySql.put(queryKey, materialization.key);
        if (tileKey != null) {
            this.actor.keyByTile.put(tileKey, materialization.key);
        }
        return key;
    }

    public CalciteSchema.TableEntry checkValid(MaterializationKey key) {
        MaterializationActor.Materialization materialization = this.actor.keyMap.get(key);
        if (materialization != null) {
            return materialization.materializedTable;
        }
        return null;
    }

    public Pair<CalciteSchema.TableEntry, TileKey> defineTile(Lattice lattice, ImmutableBitSet groupSet, List<Lattice.Measure> measureList, CalciteSchema schema, boolean create, boolean exact) {
        return this.defineTile(lattice, groupSet, measureList, schema, create, exact, "m" + groupSet, this.tableFactory);
    }

    public Pair<CalciteSchema.TableEntry, TileKey> defineTile(Lattice lattice, ImmutableBitSet groupSet, List<Lattice.Measure> measureList, CalciteSchema schema, boolean create, boolean exact, String suggestedTableName, TableFactory tableFactory) {
        CalciteSchema.TableEntry tableEntry;
        CalciteSchema.TableEntry tableEntry2;
        TileKey tileKey = new TileKey(lattice, groupSet, ImmutableList.copyOf(measureList));
        MaterializationKey materializationKey = this.actor.keyByTile.get(tileKey);
        if (materializationKey != null && (tableEntry2 = this.checkValid(materializationKey)) != null) {
            return Pair.of(tableEntry2, tileKey);
        }
        TileKey tileKey0 = new TileKey(lattice, groupSet, ImmutableList.of());
        for (TileKey tileKey2 : this.actor.tilesByDimensionality.get(tileKey0)) {
            CalciteSchema.TableEntry tableEntry3;
            assert (tileKey2.dimensions.equals(groupSet));
            if (!this.allSatisfiable(measureList, tileKey2) || (materializationKey = this.actor.keyByTile.get(tileKey2)) == null || (tableEntry3 = this.checkValid(materializationKey)) == null) continue;
            return Pair.of(tableEntry3, tileKey2);
        }
        if (!exact) {
            PriorityQueue<Pair<CalciteSchema.TableEntry, TileKey>> queue = new PriorityQueue<Pair<CalciteSchema.TableEntry, TileKey>>(1, C);
            for (Map.Entry<TileKey, MaterializationKey> entry : this.actor.keyByTile.entrySet()) {
                TileKey tileKey2 = entry.getKey();
                if (tileKey2.lattice != lattice || !tileKey2.dimensions.contains(groupSet) || tileKey2.dimensions.equals(groupSet) || !this.allSatisfiable(measureList, tileKey2) || (tableEntry = this.checkValid(materializationKey = entry.getValue())) == null) continue;
                queue.add(Pair.of(tableEntry, tileKey2));
            }
            if (!queue.isEmpty()) {
                return queue.peek();
            }
        }
        if (!create) {
            return null;
        }
        ArrayList<TileKey> obsolete = Lists.newArrayList();
        LinkedHashSet<Lattice.Measure> linkedHashSet = Sets.newLinkedHashSet();
        for (TileKey tileKey1 : this.actor.tilesByDimensionality.get(tileKey0)) {
            linkedHashSet.addAll(tileKey1.measures);
            obsolete.add(tileKey1);
        }
        linkedHashSet.addAll(measureList);
        TileKey tileKey3 = new TileKey(lattice, groupSet, ImmutableList.copyOf(linkedHashSet));
        String sql = lattice.sql(groupSet, tileKey3.measures);
        materializationKey = this.defineMaterialization(schema, tileKey3, sql, schema.path(null), suggestedTableName, tableFactory, true, false);
        if (materializationKey != null && (tableEntry = this.checkValid(materializationKey)) != null) {
            for (TileKey tileKey1 : obsolete) {
                this.actor.tilesByDimensionality.remove(tileKey0, tileKey1);
                this.actor.keyByTile.remove(tileKey1);
            }
            this.actor.tilesByDimensionality.put(tileKey0, tileKey3);
            this.actor.keyByTile.put(tileKey3, materializationKey);
            return Pair.of(tableEntry, tileKey3);
        }
        return null;
    }

    private boolean allSatisfiable(List<Lattice.Measure> measureList, TileKey tileKey) {
        for (Lattice.Measure measure : measureList) {
            if (tileKey.measures.contains(measure) || tileKey.dimensions.contains(measure.argBitSet())) continue;
            return false;
        }
        return true;
    }

    public List<Prepare.Materialization> query(CalciteSchema rootSchema) {
        ArrayList<Prepare.Materialization> list = new ArrayList<Prepare.Materialization>();
        for (MaterializationActor.Materialization materialization : this.actor.keyMap.values()) {
            if (materialization.rootSchema != rootSchema || materialization.materializedTable == null) continue;
            list.add(new Prepare.Materialization(materialization.materializedTable, materialization.sql));
        }
        return list;
    }

    public void clear() {
        this.actor.keyMap.clear();
    }

    public static void setThreadLocal() {
        THREAD_INSTANCE.set(new MaterializationService());
    }

    public static MaterializationService instance() {
        MaterializationService materializationService = THREAD_INSTANCE.get();
        if (materializationService != null) {
            return materializationService;
        }
        return INSTANCE;
    }

    public static class DefaultTableFactory
    implements TableFactory {
        @Override
        public Table createTable(CalciteSchema schema, String viewSql, List<String> viewSchemaPath) {
            final CalciteConnection connection = CalciteMetaImpl.connect(schema.root(), null);
            ImmutableMap<CalciteConnectionProperty, String> map = ImmutableMap.of(CalciteConnectionProperty.CREATE_MATERIALIZATIONS, "false");
            final CalcitePrepare.CalciteSignature<Object> calciteSignature = Schemas.prepare(connection, schema, viewSchemaPath, viewSql, map);
            return CloneSchema.createCloneTable(connection.getTypeFactory(), RelDataTypeImpl.proto(calciteSignature.rowType), Lists.transform(calciteSignature.columns, new Function<ColumnMetaData, ColumnMetaData.Rep>(){

                @Override
                public ColumnMetaData.Rep apply(ColumnMetaData column) {
                    return column.type.rep;
                }
            }), new AbstractQueryable<Object>(){

                public Enumerator<Object> enumerator() {
                    DataContext dataContext = Schemas.createDataContext(connection);
                    return calciteSignature.enumerable(dataContext).enumerator();
                }

                public Type getElementType() {
                    return Object.class;
                }

                public Expression getExpression() {
                    throw new UnsupportedOperationException();
                }

                public QueryProvider getProvider() {
                    return connection;
                }

                public Iterator<Object> iterator() {
                    DataContext dataContext = Schemas.createDataContext(connection);
                    return calciteSignature.enumerable(dataContext).iterator();
                }
            });
        }
    }

    public static interface TableFactory {
        public Table createTable(CalciteSchema var1, String var2, List<String> var3);
    }
}

