/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.jdbc;

import hive.com.google.common.collect.ImmutableMap;
import hive.org.apache.calcite.avatica.MetaImpl;
import hive.org.apache.calcite.jdbc.CalciteMetaImpl;
import hive.org.apache.calcite.linq4j.Enumerable;
import hive.org.apache.calcite.linq4j.Enumerator;
import hive.org.apache.calcite.linq4j.function.Function1;
import hive.org.apache.calcite.schema.Schema;
import hive.org.apache.calcite.schema.Table;
import hive.org.apache.calcite.schema.impl.AbstractSchema;
import java.util.Map;

class MetadataSchema
extends AbstractSchema {
    private static final Map<String, Table> TABLE_MAP = ImmutableMap.of("COLUMNS", new CalciteMetaImpl.MetadataTable<MetaImpl.MetaColumn>(MetaImpl.MetaColumn.class){

        @Override
        public Enumerator<MetaImpl.MetaColumn> enumerator(final CalciteMetaImpl meta) {
            String catalog = meta.getConnection().getCatalog();
            return meta.tables(catalog).selectMany((Function1)new Function1<MetaImpl.MetaTable, Enumerable<MetaImpl.MetaColumn>>(){

                public Enumerable<MetaImpl.MetaColumn> apply(MetaImpl.MetaTable table) {
                    return meta.columns(table);
                }
            }).enumerator();
        }
    }, "TABLES", new CalciteMetaImpl.MetadataTable<MetaImpl.MetaTable>(MetaImpl.MetaTable.class){

        @Override
        public Enumerator<MetaImpl.MetaTable> enumerator(CalciteMetaImpl meta) {
            String catalog = meta.getConnection().getCatalog();
            return meta.tables(catalog).enumerator();
        }
    });
    public static final Schema INSTANCE = new MetadataSchema();

    private MetadataSchema() {
    }

    @Override
    protected Map<String, Table> getTableMap() {
        return TABLE_MAP;
    }
}

