/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.jdbc;

import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.avatica.AvaticaConnection;
import hive.org.apache.calcite.avatica.BuiltInConnectionProperty;
import hive.org.apache.calcite.avatica.ConnectionProperty;
import hive.org.apache.calcite.avatica.DriverVersion;
import hive.org.apache.calcite.avatica.Handler;
import hive.org.apache.calcite.avatica.HandlerImpl;
import hive.org.apache.calcite.avatica.Meta;
import hive.org.apache.calcite.avatica.UnregisteredDriver;
import hive.org.apache.calcite.config.CalciteConnectionProperty;
import hive.org.apache.calcite.jdbc.CalciteConnection;
import hive.org.apache.calcite.jdbc.CalciteConnectionImpl;
import hive.org.apache.calcite.jdbc.CalciteFactory;
import hive.org.apache.calcite.jdbc.CalciteMetaImpl;
import hive.org.apache.calcite.jdbc.CalcitePrepare;
import hive.org.apache.calcite.jdbc.CalciteRootSchema;
import hive.org.apache.calcite.linq4j.function.Function0;
import hive.org.apache.calcite.model.ModelHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;

public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:calcite:";
    final Function0<CalcitePrepare> prepareFactory = this.createPrepareFactory();

    protected Function0<CalcitePrepare> createPrepareFactory() {
        return CalcitePrepare.DEFAULT_FACTORY;
    }

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: 
            case JDBC_40: {
                throw new IllegalArgumentException("JDBC version not supported: " + (Object)((Object)jdbcVersion));
            }
        }
        return "hive.org.apache.calcite.jdbc.CalciteJdbc41Factory";
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "org-apache-calcite-jdbc.properties", "Calcite JDBC Driver", "unknown version", "Calcite", "unknown version");
    }

    @Override
    protected Handler createHandler() {
        return new HandlerImpl(){

            @Override
            public void onConnectionInit(AvaticaConnection connection_) throws SQLException {
                CalciteConnectionImpl connection = (CalciteConnectionImpl)connection_;
                super.onConnectionInit(connection);
                String model = connection.config().model();
                if (model != null) {
                    try {
                        new ModelHandler(connection, model);
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                }
                connection.init();
            }
        };
    }

    @Override
    protected Collection<ConnectionProperty> getConnectionProperties() {
        ArrayList<ConnectionProperty> list = new ArrayList<ConnectionProperty>();
        Collections.addAll(list, BuiltInConnectionProperty.values());
        Collections.addAll(list, CalciteConnectionProperty.values());
        return list;
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        return new CalciteMetaImpl((CalciteConnectionImpl)connection);
    }

    CalciteConnection connect(CalciteRootSchema rootSchema, JavaTypeFactory typeFactory) {
        return (CalciteConnection)((Object)((CalciteFactory)this.factory).newConnection(this, this.factory, CONNECT_STRING_PREFIX, new Properties(), rootSchema, typeFactory));
    }

    static {
        new Driver().register();
    }
}

