/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.interpreter;

import java.util.Arrays;

public class Row {
    private final Object[] values;

    Row(Object[] values) {
        this.values = values;
    }

    public static Row asCopy(Object ... values) {
        return new Row((Object[])values.clone());
    }

    public static Row of(Object value0) {
        return new Row(new Object[]{value0});
    }

    public static Row of(Object value0, Object value1) {
        return new Row(new Object[]{value0, value1});
    }

    public static Row of(Object value0, Object value1, Object value2) {
        return new Row(new Object[]{value0, value1, value2});
    }

    public static Row of(Object ... values) {
        return new Row(values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Row && Arrays.equals(this.values, ((Row)obj).values);
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    public Object getObject(int index) {
        return this.values[index];
    }

    Object[] getValues() {
        return this.values;
    }

    public int size() {
        return this.values.length;
    }

    public static RowBuilder newBuilder(int size) {
        return new RowBuilder(size);
    }

    public static class RowBuilder {
        Object[] values;

        private RowBuilder(int size) {
            this.values = new Object[size];
        }

        public void set(int index, Object value) {
            this.values[index] = value;
        }

        public Row build() {
            return new Row(this.values);
        }

        public int size() {
            return this.values.length;
        }
    }
}

