/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.avatica.util;

import java.math.BigDecimal;

public enum TimeUnit {
    YEAR(true, ' ', 12L, null),
    MONTH(true, '-', 1L, BigDecimal.valueOf(12L)),
    DAY(false, '-', 86400000L, null),
    HOUR(false, ' ', 3600000L, BigDecimal.valueOf(24L)),
    MINUTE(false, ':', 60000L, BigDecimal.valueOf(60L)),
    SECOND(false, ':', 1000L, BigDecimal.valueOf(60L));

    public final boolean yearMonth;
    public final char separator;
    public final long multiplier;
    private final BigDecimal limit;
    private static final TimeUnit[] CACHED_VALUES;

    private TimeUnit(boolean yearMonth, char separator, long multiplier, BigDecimal limit) {
        this.yearMonth = yearMonth;
        this.separator = separator;
        this.multiplier = multiplier;
        this.limit = limit;
    }

    public static TimeUnit getValue(int ordinal) {
        return ordinal < 0 || ordinal >= CACHED_VALUES.length ? null : CACHED_VALUES[ordinal];
    }

    public boolean isValidValue(BigDecimal field) {
        return field.compareTo(BigDecimal.ZERO) >= 0 && (this.limit == null || field.compareTo(this.limit) < 0);
    }

    static {
        CACHED_VALUES = TimeUnit.values();
    }
}

