/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.avatica.util;

import hive.org.apache.calcite.avatica.util.AbstractCursor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public abstract class PositionedCursor<T>
extends AbstractCursor {
    protected abstract T current();

    protected class MapGetter<K>
    extends AbstractCursor.AbstractGetter {
        protected final K key;

        public MapGetter(K key) {
            super(PositionedCursor.this);
            this.key = key;
        }

        @Override
        public Object getObject() {
            Map map = (Map)PositionedCursor.this.current();
            Object o = map.get(this.key);
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class FieldGetter
    extends AbstractCursor.AbstractGetter {
        protected final Field field;

        public FieldGetter(Field field) {
            super(PositionedCursor.this);
            this.field = field;
        }

        @Override
        public Object getObject() {
            Object o;
            try {
                o = this.field.get(PositionedCursor.this.current());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class ObjectGetter
    extends AbstractCursor.AbstractGetter {
        public ObjectGetter(int field) {
            super(PositionedCursor.this);
            assert (field == 0);
        }

        @Override
        public Object getObject() {
            Object o = PositionedCursor.this.current();
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class ListGetter
    extends AbstractCursor.AbstractGetter {
        protected final int index;

        public ListGetter(int index) {
            super(PositionedCursor.this);
            this.index = index;
        }

        @Override
        public Object getObject() {
            Object o = ((List)PositionedCursor.this.current()).get(this.index);
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class ArrayGetter
    extends AbstractCursor.AbstractGetter {
        protected final int field;

        public ArrayGetter(int field) {
            super(PositionedCursor.this);
            this.field = field;
        }

        @Override
        public Object getObject() {
            Object o = ((Object[])PositionedCursor.this.current())[this.field];
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }
}

