/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.avatica;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import hive.org.apache.calcite.avatica.SqlType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ColumnMetaData {
    public final int ordinal;
    public final boolean autoIncrement;
    public final boolean caseSensitive;
    public final boolean searchable;
    public final boolean currency;
    public final int nullable;
    public final boolean signed;
    public final int displaySize;
    public final String label;
    public final String columnName;
    public final String schemaName;
    public final int precision;
    public final int scale;
    public final String tableName;
    public final String catalogName;
    public final boolean readOnly;
    public final boolean writable;
    public final boolean definitelyWritable;
    public final String columnClassName;
    public final AvaticaType type;

    @JsonCreator
    public ColumnMetaData(@JsonProperty(value="ordinal") int ordinal, @JsonProperty(value="autoIncrement") boolean autoIncrement, @JsonProperty(value="caseSensitive") boolean caseSensitive, @JsonProperty(value="searchable") boolean searchable, @JsonProperty(value="currency") boolean currency, @JsonProperty(value="nullable") int nullable, @JsonProperty(value="signed") boolean signed, @JsonProperty(value="displaySize") int displaySize, @JsonProperty(value="label") String label, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="precision") int precision, @JsonProperty(value="scale") int scale, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="type") AvaticaType type, @JsonProperty(value="readOnly") boolean readOnly, @JsonProperty(value="writable") boolean writable, @JsonProperty(value="definitelyWritable") boolean definitelyWritable, @JsonProperty(value="columnClassName") String columnClassName) {
        this.ordinal = ordinal;
        this.autoIncrement = autoIncrement;
        this.caseSensitive = caseSensitive;
        this.searchable = searchable;
        this.currency = currency;
        this.nullable = nullable;
        this.signed = signed;
        this.displaySize = displaySize;
        this.label = label;
        this.columnName = ColumnMetaData.first(columnName, label);
        this.schemaName = schemaName;
        this.precision = precision;
        this.scale = scale;
        this.tableName = tableName;
        this.catalogName = catalogName;
        this.type = type;
        this.readOnly = readOnly;
        this.writable = writable;
        this.definitelyWritable = definitelyWritable;
        this.columnClassName = columnClassName;
    }

    private static <T> T first(T t0, T t1) {
        return t0 != null ? t0 : t1;
    }

    public static ScalarType scalar(int type, String typeName, Rep rep) {
        return new ScalarType(type, typeName, rep);
    }

    public static StructType struct(List<ColumnMetaData> columns) {
        return new StructType(columns);
    }

    public static ArrayType array(AvaticaType componentType, String typeName, Rep rep) {
        return new ArrayType(2003, typeName, rep, componentType);
    }

    public static ColumnMetaData dummy(AvaticaType type, boolean nullable) {
        return new ColumnMetaData(0, false, true, false, false, nullable ? 1 : 0, true, -1, null, null, null, -1, -1, null, null, type, true, false, false, type.columnClassName());
    }

    public ColumnMetaData setRep(Rep rep) {
        return new ColumnMetaData(this.ordinal, this.autoIncrement, this.caseSensitive, this.searchable, this.currency, this.nullable, this.signed, this.displaySize, this.label, this.columnName, this.schemaName, this.precision, this.scale, this.tableName, this.catalogName, this.type.setRep(rep), this.readOnly, this.writable, this.definitelyWritable, this.columnClassName);
    }

    public static class ArrayType
    extends AvaticaType {
        public final AvaticaType component;

        private ArrayType(int type, String typeName, Rep representation, AvaticaType component) {
            super(type, typeName, representation);
            this.component = component;
        }
    }

    public static class StructType
    extends AvaticaType {
        public final List<ColumnMetaData> columns;

        @JsonCreator
        public StructType(List<ColumnMetaData> columns) {
            super(2002, "STRUCT", Rep.OBJECT);
            this.columns = columns;
        }
    }

    public static class ScalarType
    extends AvaticaType {
        @JsonCreator
        public ScalarType(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name, @JsonProperty(value="rep") Rep rep) {
            super(id, name, rep);
        }

        @Override
        public AvaticaType setRep(Rep rep) {
            return new ScalarType(this.id, this.name, rep);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=ScalarType.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ScalarType.class, name="scalar"), @JsonSubTypes.Type(value=StructType.class, name="struct"), @JsonSubTypes.Type(value=ArrayType.class, name="array")})
    public static class AvaticaType {
        public final int id;
        public final String name;
        public final Rep rep;

        protected AvaticaType(int id, String name, Rep rep) {
            this.id = id;
            this.name = Objects.requireNonNull(name);
            this.rep = Objects.requireNonNull(rep);
        }

        public String columnClassName() {
            return SqlType.valueOf((int)this.id).clazz.getName();
        }

        public AvaticaType setRep(Rep rep) {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Rep {
        PRIMITIVE_BOOLEAN(Boolean.TYPE),
        PRIMITIVE_BYTE(Byte.TYPE),
        PRIMITIVE_CHAR(Character.TYPE),
        PRIMITIVE_SHORT(Short.TYPE),
        PRIMITIVE_INT(Integer.TYPE),
        PRIMITIVE_LONG(Long.TYPE),
        PRIMITIVE_FLOAT(Float.TYPE),
        PRIMITIVE_DOUBLE(Double.TYPE),
        BOOLEAN(Boolean.class),
        BYTE(Byte.class),
        CHARACTER(Character.class),
        SHORT(Short.class),
        INTEGER(Integer.class),
        LONG(Long.class),
        FLOAT(Float.class),
        DOUBLE(Double.class),
        JAVA_SQL_TIME(Time.class),
        JAVA_SQL_TIMESTAMP(Timestamp.class),
        JAVA_SQL_DATE(Date.class),
        JAVA_UTIL_DATE(java.util.Date.class),
        STRING(String.class),
        OBJECT(Object.class);

        public final Class clazz;
        public static final Map<Class, Rep> VALUE_MAP;

        private Rep(Class clazz) {
            this.clazz = clazz;
        }

        public static Rep of(Type clazz) {
            Rep rep = VALUE_MAP.get(clazz);
            return rep != null ? rep : OBJECT;
        }

        static {
            HashMap<Class, Rep> builder = new HashMap<Class, Rep>();
            for (Rep rep : Rep.values()) {
                builder.put(rep.clazz, rep);
            }
            VALUE_MAP = Collections.unmodifiableMap(builder);
        }
    }
}

