/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.com.google.common.base.Supplier;
import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import hive.org.apache.calcite.adapter.enumerable.PhysType;
import hive.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.Statement;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelTrait;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollationTraitDef;
import hive.org.apache.calcite.rel.RelDistribution;
import hive.org.apache.calcite.rel.RelDistributionTraitDef;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelWriter;
import hive.org.apache.calcite.rel.SingleRel;
import hive.org.apache.calcite.rel.metadata.RelMdCollation;
import hive.org.apache.calcite.rel.metadata.RelMdDistribution;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.BuiltInMethod;
import java.lang.reflect.Method;
import java.util.List;

public class EnumerableLimit
extends SingleRel
implements EnumerableRel {
    public final RexNode offset;
    public final RexNode fetch;

    public EnumerableLimit(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, input);
        this.offset = offset;
        this.fetch = fetch;
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() == input.getConvention());
    }

    public static EnumerableLimit create(final RelNode input, RexNode offset, RexNode fetch) {
        RelOptCluster cluster = input.getCluster();
        final RelMetadataQuery mq = RelMetadataQuery.instance();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            @Override
            public List<RelCollation> get() {
                return RelMdCollation.limit(mq, input);
            }
        }).replaceIf(RelDistributionTraitDef.INSTANCE, new Supplier<RelDistribution>(){

            @Override
            public RelDistribution get() {
                return RelMdDistribution.limit(mq, input);
            }
        });
        return new EnumerableLimit(cluster, traitSet, input, offset, fetch);
    }

    @Override
    public EnumerableLimit copy(RelTraitSet traitSet, List<RelNode> newInputs) {
        return new EnumerableLimit(this.getCluster(), traitSet, EnumerableLimit.sole(newInputs), this.offset, this.fetch);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("offset", this.offset, this.offset != null).itemIf("fetch", this.fetch, this.fetch != null);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
        Expression v = builder.append("child", result.block);
        if (this.offset != null) {
            v = builder.append("offset", (Expression)Expressions.call((Expression)v, (Method)BuiltInMethod.SKIP.method, (Expression[])new Expression[]{Expressions.constant((Object)RexLiteral.intValue(this.offset))}));
        }
        if (this.fetch != null) {
            v = builder.append("fetch", (Expression)Expressions.call((Expression)v, (Method)BuiltInMethod.TAKE.method, (Expression[])new Expression[]{Expressions.constant((Object)RexLiteral.intValue(this.fetch))}));
        }
        builder.add((Statement)Expressions.return_(null, (Expression)v));
        return implementor.result(physType, builder.toBlock());
    }
}

