/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import hive.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import hive.org.apache.calcite.adapter.enumerable.PhysType;
import hive.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.interpreter.Interpreter;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.SingleRel;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.util.BuiltInMethod;
import java.lang.reflect.Method;
import java.util.List;

public class EnumerableInterpreter
extends SingleRel
implements EnumerableRel {
    private final double factor;

    public EnumerableInterpreter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, double factor) {
        super(cluster, traitSet, input);
        assert (this.getConvention() instanceof EnumerableConvention);
        this.factor = factor;
    }

    public static EnumerableInterpreter create(RelNode input, double factor) {
        RelTraitSet traitSet = input.getTraitSet().replace(EnumerableConvention.INSTANCE);
        return new EnumerableInterpreter(input.getCluster(), traitSet, input, factor);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(this.factor);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableInterpreter(this.getCluster(), traitSet, EnumerableInterpreter.sole(inputs), this.factor);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), JavaRowFormat.ARRAY);
        Expression interpreter_ = builder.append("interpreter", (Expression)Expressions.new_(Interpreter.class, (Expression[])new Expression[]{implementor.getRootExpression(), implementor.stash(this.getInput(), RelNode.class)}));
        Expression sliced_ = this.getRowType().getFieldCount() == 1 ? Expressions.call((Method)BuiltInMethod.SLICE0.method, (Expression[])new Expression[]{interpreter_}) : interpreter_;
        builder.add(sliced_);
        return implementor.result(physType, builder.toBlock());
    }
}

