/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.clone;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.adapter.java.AbstractQueryableTable;
import hive.org.apache.calcite.linq4j.AbstractQueryable;
import hive.org.apache.calcite.linq4j.Enumerator;
import hive.org.apache.calcite.linq4j.Linq4j;
import hive.org.apache.calcite.linq4j.QueryProvider;
import hive.org.apache.calcite.linq4j.Queryable;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rel.type.RelProtoDataType;
import hive.org.apache.calcite.schema.SchemaPlus;
import hive.org.apache.calcite.schema.Statistic;
import hive.org.apache.calcite.schema.Statistics;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class ListTable
extends AbstractQueryableTable {
    private final RelProtoDataType protoRowType;
    private final Expression expression;
    private final List list;

    public ListTable(Type elementType, RelProtoDataType protoRowType, Expression expression, List list) {
        super(elementType);
        this.protoRowType = protoRowType;
        this.expression = expression;
        this.list = list;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public Statistic getStatistic() {
        return Statistics.of(this.list.size(), ImmutableList.of());
    }

    @Override
    public <T> Queryable<T> asQueryable(final QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractQueryable<T>(){

            public Type getElementType() {
                return ListTable.this.elementType;
            }

            public Expression getExpression() {
                return ListTable.this.expression;
            }

            public QueryProvider getProvider() {
                return queryProvider;
            }

            public Iterator<T> iterator() {
                return ListTable.this.list.iterator();
            }

            public Enumerator<T> enumerator() {
                return Linq4j.enumerator((Collection)ListTable.this.list);
            }
        };
    }
}

