/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.base.Predicate;
import java.util.List;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.CyclicMetadataException;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;

public class RelMdColumnUniqueness
implements MetadataHandler<BuiltInMetadata.ColumnUniqueness> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.COLUMN_UNIQUENESS.method, new RelMdColumnUniqueness());
    private static final Predicate<RelNode> SAFE_REL = new Predicate<RelNode>(){

        public boolean apply(RelNode r) {
            return r instanceof Aggregate || r instanceof Project;
        }
    };

    private RelMdColumnUniqueness() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.ColumnUniqueness> getDef() {
        return BuiltInMetadata.ColumnUniqueness.DEF;
    }

    public Boolean areColumnsUnique(TableScan rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        return rel.getTable().isKey(columns);
    }

    public Boolean areColumnsUnique(Filter rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        return mq.areColumnsUnique(rel.getInput(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(RelNode rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        return null;
    }

    public Boolean areColumnsUnique(SetOp rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        return !rel.all && columns.nextClearBit(0) >= rel.getRowType().getFieldCount();
    }

    public Boolean areColumnsUnique(Intersect rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        if (this.areColumnsUnique((SetOp)rel, mq, columns, ignoreNulls).booleanValue()) {
            return true;
        }
        for (RelNode input : rel.getInputs()) {
            Boolean b = mq.areColumnsUnique(input, columns, ignoreNulls);
            if (b == null || !b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean areColumnsUnique(Minus rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        if (this.areColumnsUnique((SetOp)rel, mq, columns, ignoreNulls).booleanValue()) {
            return true;
        }
        return mq.areColumnsUnique(rel.getInput(0), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(Sort rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        return mq.areColumnsUnique(rel.getInput(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(Exchange rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        return mq.areColumnsUnique(rel.getInput(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(Correlate rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        return mq.areColumnsUnique(rel.getLeft(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(Project rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        List<RexNode> projExprs = rel.getProjects();
        ImmutableBitSet.Builder childColumns = ImmutableBitSet.builder();
        for (int bit : columns) {
            RelDataType origType;
            RelDataTypeFactory typeFactory;
            RelDataType castType;
            RexNode castOperand;
            RexCall call;
            RexNode projExpr = projExprs.get(bit);
            if (projExpr instanceof RexInputRef) {
                childColumns.set(((RexInputRef)projExpr).getIndex());
                continue;
            }
            if (!(projExpr instanceof RexCall) || !ignoreNulls || (call = (RexCall)projExpr).getOperator() != SqlStdOperatorTable.CAST || !((castOperand = call.getOperands().get(0)) instanceof RexInputRef) || !(castType = (typeFactory = rel.getCluster().getTypeFactory()).createTypeWithNullability(projExpr.getType(), true)).equals(origType = typeFactory.createTypeWithNullability(castOperand.getType(), true))) continue;
            childColumns.set(((RexInputRef)castOperand).getIndex());
        }
        if (childColumns.cardinality() == 0) {
            return null;
        }
        return mq.areColumnsUnique(rel.getInput(), childColumns.build(), ignoreNulls);
    }

    public Boolean areColumnsUnique(Join rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        if (columns.cardinality() == 0) {
            return false;
        }
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        ImmutableBitSet.Builder leftBuilder = ImmutableBitSet.builder();
        ImmutableBitSet.Builder rightBuilder = ImmutableBitSet.builder();
        int nLeftColumns = left.getRowType().getFieldCount();
        for (int bit : columns) {
            if (bit < nLeftColumns) {
                leftBuilder.set(bit);
                continue;
            }
            rightBuilder.set(bit - nLeftColumns);
        }
        ImmutableBitSet leftColumns = leftBuilder.build();
        Boolean leftUnique = mq.areColumnsUnique(left, leftColumns, ignoreNulls);
        ImmutableBitSet rightColumns = rightBuilder.build();
        Boolean rightUnique = mq.areColumnsUnique(right, rightColumns, ignoreNulls);
        if (leftColumns.cardinality() > 0 && rightColumns.cardinality() > 0) {
            if (leftUnique == null || rightUnique == null) {
                return null;
            }
            return leftUnique != false && rightUnique != false;
        }
        JoinInfo joinInfo = rel.analyzeCondition();
        if (leftColumns.cardinality() > 0) {
            if (rel.getJoinType().generatesNullsOnLeft()) {
                return false;
            }
            Boolean rightJoinColsUnique = mq.areColumnsUnique(right, joinInfo.rightSet(), ignoreNulls);
            if (rightJoinColsUnique == null || leftUnique == null) {
                return null;
            }
            return rightJoinColsUnique != false && leftUnique != false;
        }
        if (rightColumns.cardinality() > 0) {
            if (rel.getJoinType().generatesNullsOnRight()) {
                return false;
            }
            Boolean leftJoinColsUnique = mq.areColumnsUnique(left, joinInfo.leftSet(), ignoreNulls);
            if (leftJoinColsUnique == null || rightUnique == null) {
                return null;
            }
            return leftJoinColsUnique != false && rightUnique != false;
        }
        throw new AssertionError();
    }

    public Boolean areColumnsUnique(SemiJoin rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        return mq.areColumnsUnique(rel.getLeft(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(Aggregate rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        ImmutableBitSet groupKey = ImmutableBitSet.range(rel.getGroupCount());
        return columns.contains(groupKey);
    }

    public Boolean areColumnsUnique(RelNode rel, ImmutableBitSet columns, boolean ignoreNulls) {
        return null;
    }

    public Boolean areColumnsUnique(HepRelVertex rel, RelMetadataQuery mq, boolean dummy, ImmutableBitSet columns, boolean ignoreNulls) {
        return mq.areColumnsUnique(rel.getCurrentRel(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(RelSubset rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        int nullCount = 0;
        for (RelNode rel2 : rel.getRels()) {
            if (!(rel2 instanceof Aggregate) && !(rel2 instanceof Filter) && !(rel2 instanceof Values) && !(rel2 instanceof TableScan) && !this.simplyProjects(rel2, columns)) continue;
            try {
                Boolean unique = mq.areColumnsUnique(rel2, columns, ignoreNulls);
                if (unique != null) {
                    if (!unique.booleanValue()) continue;
                    return true;
                }
                ++nullCount;
            }
            catch (CyclicMetadataException cyclicMetadataException) {}
        }
        return nullCount == 0 ? Boolean.valueOf(false) : null;
    }

    private boolean simplyProjects(RelNode rel, ImmutableBitSet columns) {
        if (!(rel instanceof Project)) {
            return false;
        }
        Project project = (Project)rel;
        List<RexNode> projects = project.getProjects();
        for (int column : columns) {
            if (column >= projects.size()) {
                return false;
            }
            if (!(projects.get(column) instanceof RexInputRef)) {
                return false;
            }
            RexInputRef ref = (RexInputRef)projects.get(column);
            if (ref.getIndex() == column) continue;
            return false;
        }
        return true;
    }
}

