/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreterRule;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.interpreter.Interpreters;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteRootSchema;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.CalciteSchemaImpl;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.CalciteMaterializer;
import org.apache.calcite.prepare.CalciteSqlValidator;
import org.apache.calcite.prepare.LixToRelTranslator;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.AggregateReduceFunctionsRule;
import org.apache.calcite.rel.rules.AggregateStarTableRule;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.FilterTableScanRule;
import org.apache.calcite.rel.rules.JoinAssociateRule;
import org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.calcite.rel.rules.JoinPushExpressionsRule;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.ProjectFilterTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectTableScanRule;
import org.apache.calcite.rel.rules.ProjectWindowTransposeRule;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.rules.TableScanRule;
import org.apache.calcite.rel.rules.ValuesReduceRule;
import org.apache.calcite.rel.stream.StreamRules;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.runtime.Typed;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class CalcitePrepareImpl
implements CalcitePrepare {
    public static final boolean DEBUG = "true".equals(System.getProperties().getProperty("calcite.debug"));
    public static final boolean COMMUTE = "true".equals(System.getProperties().getProperty("calcite.enable.join.commute"));
    private static final boolean ENABLE_COLLATION_TRAIT = true;
    public static final boolean ENABLE_BINDABLE = false;
    public static final boolean ENABLE_ENUMERABLE = true;
    public static final boolean ENABLE_STREAM = true;
    private static final Set<String> SIMPLE_SQLS = ImmutableSet.of((Object)"SELECT 1", (Object)"select 1", (Object)"SELECT 1 FROM DUAL", (Object)"select 1 from dual", (Object)"values 1", (Object)"VALUES 1", (Object[])new String[0]);
    private static final List<RelOptRule> ENUMERABLE_RULES = ImmutableList.of((Object)EnumerableRules.ENUMERABLE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_MERGE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_SEMI_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_CORRELATE_RULE, (Object)EnumerableRules.ENUMERABLE_PROJECT_RULE, (Object)EnumerableRules.ENUMERABLE_FILTER_RULE, (Object)EnumerableRules.ENUMERABLE_AGGREGATE_RULE, (Object)EnumerableRules.ENUMERABLE_SORT_RULE, (Object)EnumerableRules.ENUMERABLE_LIMIT_RULE, (Object)EnumerableRules.ENUMERABLE_COLLECT_RULE, (Object)EnumerableRules.ENUMERABLE_UNCOLLECT_RULE, (Object)EnumerableRules.ENUMERABLE_UNION_RULE, (Object[])new RelOptRule[]{EnumerableRules.ENUMERABLE_INTERSECT_RULE, EnumerableRules.ENUMERABLE_MINUS_RULE, EnumerableRules.ENUMERABLE_TABLE_MODIFICATION_RULE, EnumerableRules.ENUMERABLE_VALUES_RULE, EnumerableRules.ENUMERABLE_WINDOW_RULE, EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE, EnumerableRules.ENUMERABLE_TABLE_FUNCTION_SCAN_RULE});
    private static final List<RelOptRule> DEFAULT_RULES = ImmutableList.of((Object)AggregateStarTableRule.INSTANCE, (Object)AggregateStarTableRule.INSTANCE2, (Object)TableScanRule.INSTANCE, (Object)(COMMUTE ? JoinAssociateRule.INSTANCE : ProjectMergeRule.INSTANCE), (Object)FilterTableScanRule.INSTANCE, (Object)ProjectFilterTransposeRule.INSTANCE, (Object)FilterProjectTransposeRule.INSTANCE, (Object)FilterJoinRule.FILTER_ON_JOIN, (Object)JoinPushExpressionsRule.INSTANCE, (Object)AggregateExpandDistinctAggregatesRule.INSTANCE, (Object)AggregateReduceFunctionsRule.INSTANCE, (Object)FilterAggregateTransposeRule.INSTANCE, (Object[])new RelOptRule[]{ProjectWindowTransposeRule.INSTANCE, JoinCommuteRule.INSTANCE, JoinPushThroughJoinRule.RIGHT, JoinPushThroughJoinRule.LEFT, SortProjectTransposeRule.INSTANCE});
    private static final List<RelOptRule> CONSTANT_REDUCTION_RULES = ImmutableList.of((Object)ReduceExpressionsRule.PROJECT_INSTANCE, (Object)ReduceExpressionsRule.FILTER_INSTANCE, (Object)ReduceExpressionsRule.CALC_INSTANCE, (Object)ReduceExpressionsRule.JOIN_INSTANCE, (Object)ValuesReduceRule.FILTER_INSTANCE, (Object)ValuesReduceRule.PROJECT_FILTER_INSTANCE, (Object)ValuesReduceRule.PROJECT_INSTANCE);

    @Override
    public CalcitePrepare.ParseResult parse(CalcitePrepare.Context context, String sql) {
        return this.parse_(context, sql, false, false, false);
    }

    @Override
    public CalcitePrepare.ConvertResult convert(CalcitePrepare.Context context, String sql) {
        return (CalcitePrepare.ConvertResult)this.parse_(context, sql, true, false, false);
    }

    @Override
    public CalcitePrepare.AnalyzeViewResult analyzeView(CalcitePrepare.Context context, String sql, boolean fail) {
        return (CalcitePrepare.AnalyzeViewResult)this.parse_(context, sql, true, true, fail);
    }

    private CalcitePrepare.ParseResult parse_(CalcitePrepare.Context context, String sql, boolean convert, boolean analyze, boolean fail) {
        SqlNode sqlNode;
        JavaTypeFactory typeFactory = context.getTypeFactory();
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(context.getRootSchema(), context.config().caseSensitive(), context.getDefaultSchemaPath(), typeFactory);
        SqlParser parser = this.createParser(sql);
        try {
            sqlNode = parser.parseStmt();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("parse failed", e);
        }
        CalciteSqlValidator validator = new CalciteSqlValidator(SqlStdOperatorTable.instance(), catalogReader, typeFactory);
        SqlNode sqlNode1 = validator.validate(sqlNode);
        if (convert) {
            return this.convert_(context, sql, analyze, fail, catalogReader, validator, sqlNode1);
        }
        return new CalcitePrepare.ParseResult(this, validator, sql, sqlNode1, validator.getValidatedNodeType(sqlNode1));
    }

    private CalcitePrepare.ParseResult convert_(CalcitePrepare.Context context, String sql, boolean analyze, boolean fail, CalciteCatalogReader catalogReader, SqlValidator validator, SqlNode sqlNode1) {
        JavaTypeFactory typeFactory = context.getTypeFactory();
        Convention resultConvention = EnumerableConvention.INSTANCE;
        HepPlanner planner = new HepPlanner(new HepProgramBuilder().build());
        planner.addRelTraitDef(ConventionTraitDef.INSTANCE);
        SqlToRelConverter.ConfigBuilder configBuilder = SqlToRelConverter.configBuilder().withTrimUnusedFields(true);
        if (analyze) {
            configBuilder.withConvertTableAccess(false);
        }
        CalcitePreparingStmt preparingStmt = new CalcitePreparingStmt(this, context, catalogReader, typeFactory, context.getRootSchema(), null, planner, resultConvention);
        SqlToRelConverter converter = preparingStmt.getSqlToRelConverter(validator, catalogReader, configBuilder.build());
        RelNode relNode = converter.convertQuery(sqlNode1, false, true);
        if (analyze) {
            return this.analyze_(validator, sql, sqlNode1, relNode, fail);
        }
        return new CalcitePrepare.ConvertResult(this, validator, sql, sqlNode1, validator.getValidatedNodeType(sqlNode1), relNode);
    }

    private CalcitePrepare.AnalyzeViewResult analyze_(SqlValidator validator, String sql, SqlNode sqlNode, RelNode rel, boolean fail) {
        List<Object> columnMapping;
        Filter filter;
        Project project;
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RelNode viewRel = rel;
        if (rel instanceof Project) {
            project = (Project)rel;
            rel = project.getInput();
        } else {
            project = null;
        }
        if (rel instanceof Filter) {
            filter = (Filter)rel;
            rel = filter.getInput();
        } else {
            filter = null;
        }
        TableScan scan = rel instanceof TableScan ? (TableScan)rel : null;
        if (scan == null) {
            if (fail) {
                throw validator.newValidationError(sqlNode, Static.RESOURCE.modifiableViewMustBeBasedOnSingleTable());
            }
            return new CalcitePrepare.AnalyzeViewResult(this, validator, sql, sqlNode, validator.getValidatedNodeType(sqlNode), rel, null, null, null, null);
        }
        RelOptTable targetRelTable = scan.getTable();
        RelDataType targetRowType = targetRelTable.getRowType();
        Table table = targetRelTable.unwrap(Table.class);
        List<String> tablePath = targetRelTable.getQualifiedName();
        assert (table != null);
        HashMap<Integer, RexNode> projectMap = new HashMap<Integer, RexNode>();
        if (project == null) {
            columnMapping = ImmutableIntList.range(0, targetRowType.getFieldCount());
        } else {
            columnMapping = new ArrayList();
            for (Ord node : Ord.zip(project.getProjects())) {
                if (node.e instanceof RexInputRef) {
                    RexInputRef rexInputRef = (RexInputRef)node.e;
                    int index = rexInputRef.getIndex();
                    if (projectMap.get(index) != null) {
                        if (fail) {
                            throw validator.newValidationError(sqlNode, Static.RESOURCE.moreThanOneMappedColumn(targetRowType.getFieldList().get(index).getName(), Util.last(tablePath)));
                        }
                        return new CalcitePrepare.AnalyzeViewResult(this, validator, sql, sqlNode, validator.getValidatedNodeType(sqlNode), rel, null, null, null, null);
                    }
                    projectMap.put(index, rexBuilder.makeInputRef(viewRel, node.i));
                    columnMapping.add(index);
                    continue;
                }
                columnMapping.add(-1);
            }
        }
        RexNode constraint = filter != null ? filter.getCondition() : rexBuilder.makeLiteral(true);
        ArrayList<RexNode> filters = new ArrayList<RexNode>();
        RelOptUtil.inferViewPredicates(projectMap, filters, constraint);
        for (RelDataTypeField field : targetRowType.getFieldList()) {
            int x = columnMapping.indexOf(field.getIndex());
            if (x >= 0) {
                assert (Util.skip(columnMapping, x + 1).indexOf(field.getIndex()) < 0) : "column projected more than once; should have checked above";
                continue;
            }
            if (projectMap.get(field.getIndex()) != null || field.getType().isNullable()) continue;
            if (fail) {
                throw validator.newValidationError(sqlNode, Static.RESOURCE.noValueSuppliedForViewColumn(field.getName(), Util.last(tablePath)));
            }
            return new CalcitePrepare.AnalyzeViewResult(this, validator, sql, sqlNode, validator.getValidatedNodeType(sqlNode), rel, null, null, null, null);
        }
        return new CalcitePrepare.AnalyzeViewResult(this, validator, sql, sqlNode, validator.getValidatedNodeType(sqlNode), rel, table, (ImmutableList<String>)ImmutableList.copyOf(tablePath), constraint, ImmutableIntList.copyOf(columnMapping));
    }

    protected SqlParser createParser(String sql) {
        return this.createParser(sql, this.createParserConfig());
    }

    protected SqlParser createParser(String sql, SqlParser.ConfigBuilder parserConfig) {
        return SqlParser.create(sql, parserConfig.build());
    }

    protected SqlParser.ConfigBuilder createParserConfig() {
        return SqlParser.configBuilder();
    }

    protected RelOptCluster createCluster(RelOptPlanner planner, RexBuilder rexBuilder) {
        return RelOptCluster.create(planner, rexBuilder);
    }

    protected List<Function1<CalcitePrepare.Context, RelOptPlanner>> createPlannerFactories() {
        return Collections.singletonList(new Function1<CalcitePrepare.Context, RelOptPlanner>(){

            public RelOptPlanner apply(CalcitePrepare.Context context) {
                return CalcitePrepareImpl.this.createPlanner(context, null, null);
            }
        });
    }

    protected RelOptPlanner createPlanner(CalcitePrepare.Context prepareContext) {
        return this.createPlanner(prepareContext, null, null);
    }

    protected RelOptPlanner createPlanner(CalcitePrepare.Context prepareContext, Context externalContext, RelOptCostFactory costFactory) {
        if (externalContext == null) {
            externalContext = Contexts.of((Object)prepareContext.config());
        }
        VolcanoPlanner planner = new VolcanoPlanner(costFactory, externalContext);
        planner.addRelTraitDef(ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef(RelCollationTraitDef.INSTANCE);
        planner.registerAbstractRelationalRules();
        RelOptUtil.registerAbstractRels(planner);
        for (RelOptRule rule : DEFAULT_RULES) {
            planner.addRule(rule);
        }
        planner.addRule(Bindables.BINDABLE_TABLE_SCAN_RULE);
        planner.addRule(ProjectTableScanRule.INSTANCE);
        planner.addRule(ProjectTableScanRule.INTERPRETER);
        for (RelOptRule rule : ENUMERABLE_RULES) {
            planner.addRule(rule);
        }
        planner.addRule(EnumerableInterpreterRule.INSTANCE);
        for (RelOptRule rule : StreamRules.RULES) {
            planner.addRule(rule);
        }
        CalcitePrepare.SparkHandler spark = prepareContext.spark();
        if (spark.enabled()) {
            spark.registerRules(new CalcitePrepare.SparkHandler.RuleSetBuilder(){

                @Override
                public void addRule(RelOptRule rule) {
                }

                @Override
                public void removeRule(RelOptRule rule) {
                }
            });
        }
        return planner;
    }

    @Override
    public <T> CalcitePrepare.CalciteSignature<T> prepareQueryable(CalcitePrepare.Context context, Queryable<T> queryable) {
        return this.prepare_(context, null, queryable, queryable.getElementType(), -1L);
    }

    @Override
    public <T> CalcitePrepare.CalciteSignature<T> prepareSql(CalcitePrepare.Context context, String sql, Queryable<T> expression, Type elementType, long maxRowCount) {
        return this.prepare_(context, sql, expression, elementType, maxRowCount);
    }

    <T> CalcitePrepare.CalciteSignature<T> prepare_(CalcitePrepare.Context context, String sql, Queryable<T> queryable, Type elementType, long maxRowCount) {
        if (SIMPLE_SQLS.contains(sql)) {
            return this.simplePrepare(context, sql);
        }
        JavaTypeFactory typeFactory = context.getTypeFactory();
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(context.getRootSchema(), context.config().caseSensitive(), context.getDefaultSchemaPath(), typeFactory);
        List<Function1<CalcitePrepare.Context, RelOptPlanner>> plannerFactories = this.createPlannerFactories();
        if (plannerFactories.isEmpty()) {
            throw new AssertionError((Object)"no planner factories");
        }
        RuntimeException exception = new RuntimeException();
        for (Function1<CalcitePrepare.Context, RelOptPlanner> plannerFactory : plannerFactories) {
            RelOptPlanner planner = (RelOptPlanner)plannerFactory.apply((Object)context);
            if (planner == null) {
                throw new AssertionError((Object)"factory returned null planner");
            }
            try {
                return this.prepare2_(context, sql, queryable, elementType, maxRowCount, catalogReader, planner);
            }
            catch (RelOptPlanner.CannotPlanException e) {
                exception = e;
            }
        }
        throw exception;
    }

    private <T> CalcitePrepare.CalciteSignature<T> simplePrepare(CalcitePrepare.Context context, String sql) {
        JavaTypeFactory typeFactory = context.getTypeFactory();
        RelDataType x = typeFactory.builder().add("EXPR$0", SqlTypeName.INTEGER).build();
        ImmutableList list = ImmutableList.of((Object)1);
        Object origin = null;
        List<Object> origins = Collections.nCopies(x.getFieldCount(), origin);
        List<ColumnMetaData> columns = this.getColumnMetaDataList(typeFactory, x, x, origins);
        Meta.CursorFactory cursorFactory = Meta.CursorFactory.deduce(columns, null);
        return new CalcitePrepare.CalciteSignature(sql, (List<AvaticaParameter>)ImmutableList.of(), (Map<String, Object>)ImmutableMap.of(), x, columns, cursorFactory, -1L, new Bindable<T>((List)list){
            final /* synthetic */ List val$list;
            {
                this.val$list = list;
            }

            @Override
            public Enumerable<T> bind(DataContext dataContext) {
                return Linq4j.asEnumerable((List)this.val$list);
            }
        });
    }

    <T> CalcitePrepare.CalciteSignature<T> prepare2_(CalcitePrepare.Context context, String sql, Queryable<T> queryable, Type elementType, long maxRowCount, CalciteCatalogReader catalogReader, RelOptPlanner planner) {
        RelDataType x;
        Prepare.PreparedResult preparedResult;
        JavaTypeFactory typeFactory = context.getTypeFactory();
        EnumerableRel.Prefer prefer = elementType == Object[].class ? EnumerableRel.Prefer.ARRAY : EnumerableRel.Prefer.CUSTOM;
        Convention resultConvention = EnumerableConvention.INSTANCE;
        CalcitePreparingStmt preparingStmt = new CalcitePreparingStmt(this, context, catalogReader, typeFactory, context.getRootSchema(), prefer, planner, resultConvention);
        if (sql != null) {
            SqlNode sqlNode;
            assert (queryable == null);
            CalciteConnectionConfig config = context.config();
            SqlParser parser = this.createParser(sql, this.createParserConfig().setQuotedCasing(config.quotedCasing()).setUnquotedCasing(config.unquotedCasing()).setQuoting(config.quoting()));
            try {
                sqlNode = parser.parseStmt();
            }
            catch (SqlParseException e) {
                throw new RuntimeException("parse failed: " + e.getMessage(), e);
            }
            Hook.PARSE_TREE.run(new Object[]{sql, sqlNode});
            CalciteRootSchema rootSchema = context.getRootSchema();
            ChainedSqlOperatorTable opTab = new ChainedSqlOperatorTable((List<SqlOperatorTable>)ImmutableList.of((Object)SqlStdOperatorTable.instance(), (Object)catalogReader));
            CalciteSqlValidator validator = new CalciteSqlValidator(opTab, catalogReader, typeFactory);
            validator.setIdentifierExpansion(true);
            validator.setDefaultNullCollation(config.defaultNullCollation());
            ImmutableList materializations = config.materializationsEnabled() ? MaterializationService.instance().query(rootSchema) : ImmutableList.of();
            for (Prepare.Materialization materialization : materializations) {
                this.populateMaterializations(context, planner, materialization);
            }
            List<CalciteSchema.LatticeEntry> lattices = Schemas.getLatticeEntries(rootSchema);
            preparedResult = preparingStmt.prepareSql(sqlNode, Object.class, validator, true, (List<Prepare.Materialization>)materializations, lattices);
            switch (sqlNode.getKind()) {
                case INSERT: 
                case EXPLAIN: {
                    x = RelOptUtil.createDmlRowType(sqlNode.getKind(), typeFactory);
                    break;
                }
                default: {
                    x = validator.getValidatedNodeType(sqlNode);
                    break;
                }
            }
        } else {
            assert (queryable != null);
            x = context.getTypeFactory().createType(elementType);
            preparedResult = preparingStmt.prepareQueryable(queryable, x);
        }
        ArrayList<AvaticaParameter> parameters = new ArrayList<AvaticaParameter>();
        RelDataType parameterRowType = preparedResult.getParameterRowType();
        for (RelDataTypeField field : parameterRowType.getFieldList()) {
            RelDataType type = field.getType();
            parameters.add(new AvaticaParameter(false, CalcitePrepareImpl.getPrecision(type), CalcitePrepareImpl.getScale(type), this.getTypeOrdinal(type), CalcitePrepareImpl.getTypeName(type), CalcitePrepareImpl.getClassName(type), field.getName()));
        }
        RelDataType jdbcType = CalcitePrepareImpl.makeStruct(typeFactory, x);
        List<List<String>> originList = preparedResult.getFieldOrigins();
        List<ColumnMetaData> columns = this.getColumnMetaDataList(typeFactory, x, jdbcType, originList);
        Class resultClazz = null;
        if (preparedResult instanceof Typed) {
            resultClazz = (Class)((Typed)((Object)preparedResult)).getElementType();
        }
        Bindable bindable = preparedResult.getBindable();
        return new CalcitePrepare.CalciteSignature(sql, parameters, preparingStmt.internalParameters, jdbcType, columns, preparingStmt.resultConvention == BindableConvention.INSTANCE ? Meta.CursorFactory.ARRAY : Meta.CursorFactory.deduce(columns, (Class)resultClazz), maxRowCount, bindable);
    }

    private List<ColumnMetaData> getColumnMetaDataList(JavaTypeFactory typeFactory, RelDataType x, RelDataType jdbcType, List<List<String>> originList) {
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        for (Ord pair : Ord.zip(jdbcType.getFieldList())) {
            RelDataTypeField field = (RelDataTypeField)pair.e;
            RelDataType type = field.getType();
            RelDataType fieldType = x.isStruct() ? x.getFieldList().get(pair.i).getType() : type;
            columns.add(this.metaData(typeFactory, columns.size(), field.getName(), type, fieldType, originList.get(pair.i)));
        }
        return columns;
    }

    private ColumnMetaData metaData(JavaTypeFactory typeFactory, int ordinal, String fieldName, RelDataType type, RelDataType fieldType, List<String> origins) {
        ColumnMetaData.AvaticaType avaticaType = this.avaticaType(typeFactory, type, fieldType);
        return new ColumnMetaData(ordinal, false, true, false, false, type.isNullable() ? 1 : 0, true, type.getPrecision(), fieldName, CalcitePrepareImpl.origin(origins, 0), CalcitePrepareImpl.origin(origins, 2), CalcitePrepareImpl.getPrecision(type), CalcitePrepareImpl.getScale(type), CalcitePrepareImpl.origin(origins, 1), null, avaticaType, true, false, false, avaticaType.columnClassName());
    }

    private ColumnMetaData.AvaticaType avaticaType(JavaTypeFactory typeFactory, RelDataType type, RelDataType fieldType) {
        Type clazz = typeFactory.getJavaClass(Util.first(fieldType, type));
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of((Type)clazz);
        assert (rep != null);
        String typeName = CalcitePrepareImpl.getTypeName(type);
        if (type.getComponentType() != null) {
            ColumnMetaData.AvaticaType componentType = this.avaticaType(typeFactory, type.getComponentType(), null);
            return ColumnMetaData.array((ColumnMetaData.AvaticaType)componentType, (String)typeName, (ColumnMetaData.Rep)rep);
        }
        return ColumnMetaData.scalar((int)this.getTypeOrdinal(type), (String)typeName, (ColumnMetaData.Rep)rep);
    }

    private static String origin(List<String> origins, int offsetFromEnd) {
        return origins == null || offsetFromEnd >= origins.size() ? null : origins.get(origins.size() - 1 - offsetFromEnd);
    }

    private int getTypeOrdinal(RelDataType type) {
        return type.getSqlTypeName().getJdbcOrdinal();
    }

    private static String getClassName(RelDataType type) {
        return null;
    }

    private static int getScale(RelDataType type) {
        return type.getScale() == Integer.MIN_VALUE ? 0 : type.getScale();
    }

    private static int getPrecision(RelDataType type) {
        return type.getPrecision() == -1 ? 0 : type.getPrecision();
    }

    private static String getTypeName(RelDataType type) {
        SqlTypeName sqlTypeName = type.getSqlTypeName();
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return sqlTypeName.getName();
        }
        switch (sqlTypeName) {
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return "INTERVAL_" + type.getIntervalQualifier().toString().replace(' ', '_');
            }
        }
        return type.toString();
    }

    protected void populateMaterializations(CalcitePrepare.Context context, RelOptPlanner planner, Prepare.Materialization materialization) {
        try {
            CalciteSchema schema = materialization.materializedTable.schema;
            CalciteCatalogReader catalogReader = new CalciteCatalogReader(schema.root(), context.config().caseSensitive(), Util.skipLast(materialization.materializedTable.path()), context.getTypeFactory());
            CalciteMaterializer materializer = new CalciteMaterializer(this, context, catalogReader, schema, planner);
            materializer.populate(materialization);
        }
        catch (Exception e) {
            throw new RuntimeException("While populating materialization " + materialization.materializedTable.path(), e);
        }
    }

    private static RelDataType makeStruct(RelDataTypeFactory typeFactory, RelDataType type) {
        if (type.isStruct()) {
            return type;
        }
        return typeFactory.builder().add("$0", type).build();
    }

    public <R> R perform(CalciteServerStatement statement, Frameworks.PrepareAction<R> action) {
        CalcitePrepare.Context prepareContext = statement.createPrepareContext();
        JavaTypeFactory typeFactory = prepareContext.getTypeFactory();
        CalciteRootSchema schema = action.getConfig().getDefaultSchema() != null ? CalciteSchemaImpl.from(action.getConfig().getDefaultSchema()) : prepareContext.getRootSchema();
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(schema.root(), prepareContext.config().caseSensitive(), schema.path(null), typeFactory);
        RexBuilder rexBuilder = new RexBuilder(typeFactory);
        RelOptPlanner planner = this.createPlanner(prepareContext, action.getConfig().getContext(), action.getConfig().getCostFactory());
        RelOptCluster cluster = this.createCluster(planner, rexBuilder);
        return action.apply(cluster, catalogReader, prepareContext.getRootSchema().plus(), statement);
    }

    private static class LambdaScalarTranslator
    extends EmptyScalarTranslator {
        private final List<ParameterExpression> parameterList;
        private final List<RexNode> values;

        public LambdaScalarTranslator(RexBuilder rexBuilder, List<ParameterExpression> parameterList, List<RexNode> values) {
            super(rexBuilder);
            this.parameterList = parameterList;
            this.values = values;
        }

        @Override
        public RexNode parameter(ParameterExpression param) {
            int i = this.parameterList.indexOf(param);
            if (i >= 0) {
                return this.values.get(i);
            }
            throw new RuntimeException("unknown parameter " + param);
        }
    }

    static class EmptyScalarTranslator
    implements ScalarTranslator {
        private final RexBuilder rexBuilder;

        public EmptyScalarTranslator(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public static ScalarTranslator empty(RexBuilder builder) {
            return new EmptyScalarTranslator(builder);
        }

        @Override
        public List<RexNode> toRexList(BlockStatement statement) {
            List<Expression> simpleList = EmptyScalarTranslator.simpleList(statement);
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            for (Expression expression1 : simpleList) {
                list.add(this.toRex(expression1));
            }
            return list;
        }

        @Override
        public RexNode toRex(BlockStatement statement) {
            return this.toRex(Blocks.simple((BlockStatement)statement));
        }

        private static List<Expression> simpleList(BlockStatement statement) {
            Expression simple = Blocks.simple((BlockStatement)statement);
            if (simple instanceof NewExpression) {
                NewExpression newExpression = (NewExpression)simple;
                return newExpression.arguments;
            }
            return Collections.singletonList(simple);
        }

        @Override
        public RexNode toRex(Expression expression) {
            switch (expression.getNodeType()) {
                case MemberAccess: {
                    return this.rexBuilder.makeFieldAccess(this.toRex(((MemberExpression)expression).expression), ((MemberExpression)expression).field.getName(), true);
                }
                case GreaterThan: {
                    return this.binary(expression, SqlStdOperatorTable.GREATER_THAN);
                }
                case LessThan: {
                    return this.binary(expression, SqlStdOperatorTable.LESS_THAN);
                }
                case Parameter: {
                    return this.parameter((ParameterExpression)expression);
                }
                case Call: {
                    MethodCallExpression call = (MethodCallExpression)expression;
                    SqlOperator operator = RexToLixTranslator.JAVA_TO_SQL_METHOD_MAP.get(call.method);
                    if (operator != null) {
                        return this.rexBuilder.makeCall(this.type((Expression)call), operator, this.toRex((List<Expression>)Expressions.list().appendIfNotNull((Object)call.targetExpression).appendAll((Iterable)call.expressions)));
                    }
                    throw new RuntimeException("Could translate call to method " + call.method);
                }
                case Constant: {
                    ConstantExpression constant = (ConstantExpression)expression;
                    Object value = constant.value;
                    if (value instanceof Number) {
                        Number number = (Number)value;
                        if (value instanceof Double || value instanceof Float) {
                            return this.rexBuilder.makeApproxLiteral(BigDecimal.valueOf(number.doubleValue()));
                        }
                        if (value instanceof BigDecimal) {
                            return this.rexBuilder.makeExactLiteral((BigDecimal)value);
                        }
                        return this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(number.longValue()));
                    }
                    if (value instanceof Boolean) {
                        return this.rexBuilder.makeLiteral((Boolean)value);
                    }
                    return this.rexBuilder.makeLiteral(constant.toString());
                }
            }
            throw new UnsupportedOperationException("unknown expression type " + expression.getNodeType() + " " + expression);
        }

        private RexNode binary(Expression expression, SqlBinaryOperator op) {
            BinaryExpression call = (BinaryExpression)expression;
            return this.rexBuilder.makeCall(this.type((Expression)call), op, this.toRex((List<Expression>)ImmutableList.of((Object)call.expression0, (Object)call.expression1)));
        }

        private List<RexNode> toRex(List<Expression> expressions) {
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            for (Expression expression : expressions) {
                list.add(this.toRex(expression));
            }
            return list;
        }

        protected RelDataType type(Expression expression) {
            Type type = expression.getType();
            return ((JavaTypeFactory)this.rexBuilder.getTypeFactory()).createType(type);
        }

        @Override
        public ScalarTranslator bind(List<ParameterExpression> parameterList, List<RexNode> values) {
            return new LambdaScalarTranslator(this.rexBuilder, parameterList, values);
        }

        public RexNode parameter(ParameterExpression param) {
            throw new RuntimeException("unknown parameter " + param);
        }
    }

    static interface ScalarTranslator {
        public RexNode toRex(BlockStatement var1);

        public List<RexNode> toRexList(BlockStatement var1);

        public RexNode toRex(Expression var1);

        public ScalarTranslator bind(List<ParameterExpression> var1, List<RexNode> var2);
    }

    private static class CalcitePreparedExplain
    extends Prepare.PreparedExplain {
        public CalcitePreparedExplain(RelDataType resultType, RelDataType parameterRowType, RelNode rootRel, boolean explainAsXml, SqlExplainLevel detailLevel) {
            super(resultType, parameterRowType, rootRel, explainAsXml, detailLevel);
        }

        @Override
        public Bindable getBindable() {
            final String explanation = this.getCode();
            return new Bindable(){

                public Enumerable bind(DataContext dataContext) {
                    return Linq4j.singletonEnumerable((Object)explanation);
                }
            };
        }
    }

    static class CalcitePreparingStmt
    extends Prepare
    implements RelOptTable.ViewExpander {
        protected final RelOptPlanner planner;
        protected final RexBuilder rexBuilder;
        protected final CalcitePrepareImpl prepare;
        protected final CalciteSchema schema;
        protected final RelDataTypeFactory typeFactory;
        private final EnumerableRel.Prefer prefer;
        private final Map<String, Object> internalParameters = Maps.newLinkedHashMap();
        private int expansionDepth;
        private SqlValidator sqlValidator;

        public CalcitePreparingStmt(CalcitePrepareImpl prepare, CalcitePrepare.Context context, Prepare.CatalogReader catalogReader, RelDataTypeFactory typeFactory, CalciteSchema schema, EnumerableRel.Prefer prefer, RelOptPlanner planner, Convention resultConvention) {
            super(context, catalogReader, resultConvention);
            this.prepare = prepare;
            this.schema = schema;
            this.prefer = prefer;
            this.planner = planner;
            this.typeFactory = typeFactory;
            this.rexBuilder = new RexBuilder(typeFactory);
        }

        @Override
        protected void init(Class runtimeContextClass) {
        }

        public Prepare.PreparedResult prepareQueryable(Queryable queryable, RelDataType resultType) {
            this.queryString = null;
            Class<Object> runtimeContextClass = Object.class;
            this.init(runtimeContextClass);
            RelOptCluster cluster = this.prepare.createCluster(this.planner, this.rexBuilder);
            RelNode rootRel = new LixToRelTranslator(cluster, this).translate(queryable);
            if (this.timingTracer != null) {
                this.timingTracer.traceTime("end sql2rel");
            }
            RelDataType jdbcType = CalcitePrepareImpl.makeStruct(this.rexBuilder.getTypeFactory(), resultType);
            this.fieldOrigins = Collections.nCopies(jdbcType.getFieldCount(), null);
            this.parameterRowType = this.rexBuilder.getTypeFactory().builder().build();
            rootRel = this.flattenTypes(rootRel, true);
            rootRel = this.trimUnusedFields(rootRel);
            ImmutableList materializations = ImmutableList.of();
            ImmutableList lattices = ImmutableList.of();
            rootRel = this.optimize(rootRel, (List<Prepare.Materialization>)materializations, (List<CalciteSchema.LatticeEntry>)lattices);
            if (this.timingTracer != null) {
                this.timingTracer.traceTime("end optimization");
            }
            return this.implement(resultType, rootRel, SqlKind.SELECT);
        }

        @Override
        protected SqlToRelConverter getSqlToRelConverter(SqlValidator validator, Prepare.CatalogReader catalogReader, SqlToRelConverter.Config config) {
            RelOptCluster cluster = this.prepare.createCluster(this.planner, this.rexBuilder);
            SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)this, validator, catalogReader, cluster, StandardConvertletTable.INSTANCE, config);
            return sqlToRelConverter;
        }

        @Override
        public RelNode flattenTypes(RelNode rootRel, boolean restructure) {
            CalcitePrepare.SparkHandler spark = this.context.spark();
            if (spark.enabled()) {
                return spark.flattenTypes(this.planner, rootRel, restructure);
            }
            return rootRel;
        }

        @Override
        protected RelNode decorrelate(SqlToRelConverter sqlToRelConverter, SqlNode query, RelNode rootRel) {
            return sqlToRelConverter.decorrelate(query, rootRel);
        }

        @Override
        public RelNode expandView(RelDataType rowType, String queryString, List<String> schemaPath) {
            SqlNode sqlNode;
            ++this.expansionDepth;
            SqlParser parser = this.prepare.createParser(queryString);
            try {
                sqlNode = parser.parseQuery();
            }
            catch (SqlParseException e) {
                throw new RuntimeException("parse failed", e);
            }
            Prepare.CatalogReader catalogReader = this.catalogReader.withSchemaPath(schemaPath);
            SqlValidatorImpl validator = this.createSqlValidator(catalogReader);
            SqlNode sqlNode1 = validator.validate(sqlNode);
            SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withTrimUnusedFields(true).build();
            SqlToRelConverter sqlToRelConverter = this.getSqlToRelConverter(validator, catalogReader, config);
            RelNode relNode = sqlToRelConverter.convertQuery(sqlNode1, true, false);
            --this.expansionDepth;
            return relNode;
        }

        private SqlValidatorImpl createSqlValidator(Prepare.CatalogReader catalogReader) {
            return new SqlValidatorImpl(SqlStdOperatorTable.instance(), catalogReader, this.rexBuilder.getTypeFactory(), SqlConformance.DEFAULT){};
        }

        @Override
        protected SqlValidator getSqlValidator() {
            if (this.sqlValidator == null) {
                this.sqlValidator = this.createSqlValidator(this.catalogReader);
            }
            return this.sqlValidator;
        }

        @Override
        protected Prepare.PreparedResult createPreparedExplanation(RelDataType resultType, RelDataType parameterRowType, RelNode rootRel, boolean explainAsXml, SqlExplainLevel detailLevel) {
            return new CalcitePreparedExplain(resultType, parameterRowType, rootRel, explainAsXml, detailLevel);
        }

        @Override
        protected Prepare.PreparedResult implement(RelDataType rowType, RelNode rootRel, SqlKind sqlKind) {
            RelDataType resultType = rootRel.getRowType();
            boolean isDml = sqlKind.belongsTo(SqlKind.DML);
            final Bindable<Object[]> bindable = this.resultConvention == BindableConvention.INSTANCE ? Interpreters.bindable(rootRel) : EnumerableInterpretable.toBindable(this.internalParameters, this.context.spark(), (EnumerableRel)rootRel, this.prefer);
            if (this.timingTracer != null) {
                this.timingTracer.traceTime("end codegen");
            }
            if (this.timingTracer != null) {
                this.timingTracer.traceTime("end compilation");
            }
            return new Prepare.PreparedResultImpl(resultType, this.parameterRowType, this.fieldOrigins, rootRel, this.mapTableModOp(isDml, sqlKind), isDml){

                @Override
                public String getCode() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Bindable getBindable() {
                    return bindable;
                }

                @Override
                public Type getElementType() {
                    return ((Typed)((Object)bindable)).getElementType();
                }
            };
        }
    }
}

