/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.MulticastRelOptListener;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.CancelFlag;
import org.apache.calcite.util.Static;

public abstract class AbstractRelOptPlanner
implements RelOptPlanner {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("[0-9]+");
    private final Map<String, RelOptRule> mapDescToRule = new HashMap<String, RelOptRule>();
    protected final RelOptCostFactory costFactory;
    private MulticastRelOptListener listener;
    private Pattern ruleDescExclusionFilter;
    private CancelFlag cancelFlag;
    private final Set<Class<? extends RelNode>> classes = new HashSet<Class<? extends RelNode>>();
    private final Set<RelTrait> traits = new HashSet<RelTrait>();
    protected final Context context;
    private RelOptPlanner.Executor executor;

    protected AbstractRelOptPlanner(RelOptCostFactory costFactory, Context context) {
        assert (costFactory != null);
        this.costFactory = costFactory;
        if (context == null) {
            context = Contexts.empty();
        }
        this.context = context;
        this.cancelFlag = new CancelFlag();
        this.classes.add(RelNode.class);
        this.classes.add(RelSubset.class);
    }

    @Override
    public void clear() {
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public RelOptCostFactory getCostFactory() {
        return this.costFactory;
    }

    @Override
    public void setCancelFlag(CancelFlag cancelFlag) {
        this.cancelFlag = cancelFlag;
    }

    public void checkCancel() {
        if (this.cancelFlag.isCancelRequested()) {
            throw Static.RESOURCE.preparationAborted().ex();
        }
    }

    protected void mapRuleDescription(RelOptRule rule) {
        String description = rule.toString();
        assert (description != null);
        assert (!description.contains("$")) : "Rule's description should not contain '$': " + description;
        assert (!INTEGER_PATTERN.matcher(description).matches()) : "Rule's description should not be an integer: " + rule.getClass().getName() + ", " + description;
        RelOptRule existingRule = this.mapDescToRule.put(description, rule);
        if (existingRule != null) {
            if (existingRule == rule) {
                throw new AssertionError((Object)"Rule should not already be registered");
            }
            throw new AssertionError((Object)("Rule's description should be unique; existing rule=" + existingRule + "; new rule=" + rule));
        }
    }

    protected void unmapRuleDescription(RelOptRule rule) {
        String description = rule.toString();
        this.mapDescToRule.remove(description);
    }

    protected RelOptRule getRuleByDescription(String description) {
        return this.mapDescToRule.get(description);
    }

    @Override
    public void setRuleDescExclusionFilter(Pattern exclusionFilter) {
        this.ruleDescExclusionFilter = exclusionFilter;
    }

    public boolean isRuleExcluded(RelOptRule rule) {
        return this.ruleDescExclusionFilter != null && this.ruleDescExclusionFilter.matcher(rule.toString()).matches();
    }

    @Override
    public RelOptPlanner chooseDelegate() {
        return this;
    }

    @Override
    public void addMaterialization(RelOptMaterialization materialization) {
    }

    @Override
    public void addLattice(RelOptLattice lattice) {
    }

    @Override
    public RelOptLattice getLattice(RelOptTable table) {
        return null;
    }

    @Override
    public void registerSchema(RelOptSchema schema) {
    }

    @Override
    public long getRelMetadataTimestamp(RelNode rel) {
        return 0L;
    }

    @Override
    public void setImportance(RelNode rel, double importance) {
    }

    @Override
    public void registerClass(RelNode node) {
        Class<?> clazz = node.getClass();
        if (this.classes.add(clazz)) {
            this.onNewClass(node);
        }
        for (RelTrait trait : node.getTraitSet()) {
            if (!this.traits.add(trait)) continue;
            trait.register(this);
        }
    }

    protected void onNewClass(RelNode node) {
        node.register(this);
    }

    @Override
    public RelTraitSet emptyTraitSet() {
        return RelTraitSet.createEmpty();
    }

    @Override
    public RelOptCost getCost(RelNode rel, RelMetadataQuery mq) {
        return mq.getCumulativeCost(rel);
    }

    @Override
    public RelOptCost getCost(RelNode rel) {
        RelMetadataQuery mq = RelMetadataQuery.instance();
        return this.getCost(rel, mq);
    }

    @Override
    public void addListener(RelOptListener newListener) {
        if (this.listener == null) {
            this.listener = new MulticastRelOptListener();
        }
        this.listener.addListener(newListener);
    }

    @Override
    public void registerMetadataProviders(List<RelMetadataProvider> list) {
    }

    @Override
    public boolean addRelTraitDef(RelTraitDef relTraitDef) {
        return false;
    }

    @Override
    public void clearRelTraitDefs() {
    }

    @Override
    public List<RelTraitDef> getRelTraitDefs() {
        return ImmutableList.of();
    }

    @Override
    public void setExecutor(RelOptPlanner.Executor executor) {
        this.executor = executor;
    }

    @Override
    public RelOptPlanner.Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void onCopy(RelNode rel, RelNode newRel) {
    }

    protected void fireRule(RelOptRuleCall ruleCall) {
        RelOptListener.RuleAttemptedEvent event;
        this.checkCancel();
        assert (ruleCall.getRule().matches(ruleCall));
        if (this.isRuleExcluded(ruleCall.getRule())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("call#" + ruleCall.id + ": Rule [" + ruleCall.getRule() + "] not fired due to exclusion filter");
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("call#" + ruleCall.id + ": Apply rule [" + ruleCall.getRule() + "] to " + Arrays.toString(ruleCall.rels));
        }
        if (this.listener != null) {
            event = new RelOptListener.RuleAttemptedEvent(this, (RelNode)ruleCall.rel(0), ruleCall, true);
            this.listener.ruleAttempted(event);
        }
        ruleCall.getRule().onMatch(ruleCall);
        if (this.listener != null) {
            event = new RelOptListener.RuleAttemptedEvent(this, (RelNode)ruleCall.rel(0), ruleCall, false);
            this.listener.ruleAttempted(event);
        }
    }

    protected void notifyTransformation(RelOptRuleCall ruleCall, RelNode newRel, boolean before) {
        if (before && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("call#" + ruleCall.id + ": Rule " + ruleCall.getRule() + " arguments " + Arrays.toString(ruleCall.rels) + " produced " + newRel);
        }
        if (this.listener != null) {
            RelOptListener.RuleProductionEvent event = new RelOptListener.RuleProductionEvent(this, newRel, ruleCall, before);
            this.listener.ruleProductionSucceeded(event);
        }
    }

    protected void notifyChosen(RelNode rel) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("For final plan, using " + rel);
        }
        if (this.listener != null) {
            RelOptListener.RelChosenEvent event = new RelOptListener.RelChosenEvent(this, rel);
            this.listener.relChosen(event);
        }
    }

    protected void notifyEquivalence(RelNode rel, Object equivalenceClass, boolean physical) {
        if (this.listener != null) {
            RelOptListener.RelEquivalenceEvent event = new RelOptListener.RelEquivalenceEvent(this, rel, equivalenceClass, physical);
            this.listener.relEquivalenceFound(event);
        }
    }

    protected void notifyDiscard(RelNode rel) {
        if (this.listener != null) {
            RelOptListener.RelDiscardedEvent event = new RelOptListener.RelDiscardedEvent(this, rel);
            this.listener.relDiscarded(event);
        }
    }

    protected MulticastRelOptListener getListener() {
        return this.listener;
    }

    public Iterable<Class<? extends RelNode>> subClasses(final Class<? extends RelNode> clazz) {
        return Iterables.filter(this.classes, (Predicate)new Predicate<Class<? extends RelNode>>(){

            public boolean apply(Class<? extends RelNode> input) {
                return clazz.isAssignableFrom(input);
            }
        });
    }
}

