/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.calcite.adapter.jdbc.JdbcToEnumerableConverterRule;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexMultisetUtil;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlSingleValueAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;

public class JdbcRules {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private static final SqlParserPos POS = SqlParserPos.ZERO;
    static final ImmutableList<SqlAggFunction> AGG_FUNCS;
    static final ImmutableList<SqlAggFunction> MYSQL_AGG_FUNCS;
    private static final SqlFunction ISNULL_FUNCTION;

    private JdbcRules() {
    }

    public static List<RelOptRule> rules(JdbcConvention out) {
        return ImmutableList.of((Object)new JdbcToEnumerableConverterRule(out), (Object)new JdbcJoinRule(out), (Object)new JdbcCalcRule(out), (Object)new JdbcProjectRule(out), (Object)new JdbcFilterRule(out), (Object)new JdbcAggregateRule(out), (Object)new JdbcSortRule(out), (Object)new JdbcUnionRule(out), (Object)new JdbcIntersectRule(out), (Object)new JdbcMinusRule(out), (Object)new JdbcTableModificationRule(out), (Object)new JdbcValuesRule(out), (Object[])new RelOptRule[0]);
    }

    private static void addSelect(List<SqlNode> selectList, SqlNode node, RelDataType rowType) {
        String name = rowType.getFieldNames().get(selectList.size());
        String alias = SqlValidatorUtil.getAlias(node, -1);
        if (alias == null || !alias.equals(name)) {
            node = SqlStdOperatorTable.AS.createCall(POS, node, new SqlIdentifier(name, POS));
        }
        selectList.add(node);
    }

    private static JdbcImplementor.Result setOpToSql(JdbcImplementor implementor, SqlSetOperator operator, JdbcRel rel) {
        Expressions.FluentList list = Expressions.list();
        for (Ord input : Ord.zip(rel.getInputs())) {
            JdbcImplementor.Result result = implementor.visitChild(input.i, (RelNode)input.e);
            list.add(result.asSelect());
        }
        SqlCall node = operator.createCall(new SqlNodeList((Collection<? extends SqlNode>)list, POS));
        Expressions.FluentList clauses = Expressions.list((Object[])new JdbcImplementor.Clause[]{JdbcImplementor.Clause.SET_OP});
        return implementor.result((SqlNode)node, (Collection<JdbcImplementor.Clause>)clauses, rel);
    }

    private static boolean isStar(List<RexNode> exps, RelDataType inputRowType) {
        int i = 0;
        for (RexNode ref : exps) {
            if (!(ref instanceof RexInputRef)) {
                return false;
            }
            if (((RexInputRef)ref).getIndex() == i++) continue;
            return false;
        }
        return i == inputRowType.getFieldCount();
    }

    private static boolean isStar(RexProgram program) {
        int i = 0;
        for (RexLocalRef ref : program.getProjectList()) {
            if (ref.getIndex() == i++) continue;
            return false;
        }
        return i == program.getInputRowType().getFieldCount();
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)SqlStdOperatorTable.COUNT);
        builder.add((Object)SqlStdOperatorTable.SUM);
        builder.add((Object)SqlStdOperatorTable.SUM0);
        builder.add((Object)SqlStdOperatorTable.MIN);
        builder.add((Object)SqlStdOperatorTable.MAX);
        AGG_FUNCS = builder.build();
        builder.add((Object)SqlStdOperatorTable.SINGLE_VALUE);
        MYSQL_AGG_FUNCS = builder.build();
        ISNULL_FUNCTION = new SqlFunction("ISNULL", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, OperandTypes.ANY, SqlFunctionCategory.SYSTEM);
    }

    public static class JdbcValues
    extends Values
    implements JdbcRel {
        JdbcValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new JdbcValues(this.getCluster(), this.rowType, (ImmutableList<ImmutableList<RexLiteral>>)this.tuples, traitSet);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            List<String> fields = this.getRowType().getFieldNames();
            List<JdbcImplementor.Clause> clauses = Collections.singletonList(JdbcImplementor.Clause.SELECT);
            JdbcImplementor jdbcImplementor = implementor;
            jdbcImplementor.getClass();
            JdbcImplementor.AliasContext context = jdbcImplementor.new JdbcImplementor.AliasContext(Collections.emptyList(), false);
            ArrayList<SqlSelect> selects = new ArrayList<SqlSelect>();
            for (List tuple : this.tuples) {
                ArrayList<SqlCall> selectList = new ArrayList<SqlCall>();
                for (Pair literal : Pair.zip(tuple, fields)) {
                    selectList.add(SqlStdOperatorTable.AS.createCall(POS, context.toSql(null, (RexNode)literal.left), new SqlIdentifier((String)literal.right, POS)));
                }
                selects.add(new SqlSelect(POS, SqlNodeList.EMPTY, new SqlNodeList(selectList, POS), null, null, null, null, null, null, null, null));
            }
            SqlCall query = null;
            for (SqlSelect select : selects) {
                if (query == null) {
                    query = select;
                    continue;
                }
                query = SqlStdOperatorTable.UNION_ALL.createCall(POS, query, select);
            }
            return implementor.result(query, clauses, this);
        }
    }

    public static class JdbcValuesRule
    extends JdbcConverterRule {
        private JdbcValuesRule(JdbcConvention out) {
            super(LogicalValues.class, (RelTrait)Convention.NONE, out, "JdbcValuesRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalValues values = (LogicalValues)rel;
            return new JdbcValues(values.getCluster(), values.getRowType(), values.getTuples(), values.getTraitSet().replace(this.out));
        }
    }

    public static class JdbcTableModify
    extends TableModify
    implements JdbcRel {
        private final Expression expression;

        public JdbcTableModify(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode input, TableModify.Operation operation, List<String> updateColumnList, boolean flattened) {
            super(cluster, traitSet, table, catalogReader, input, operation, updateColumnList, flattened);
            assert (input.getConvention() instanceof JdbcConvention);
            assert (this.getConvention() instanceof JdbcConvention);
            ModifiableTable modifiableTable = table.unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                throw new AssertionError();
            }
            this.expression = table.getExpression(Queryable.class);
            if (this.expression == null) {
                throw new AssertionError();
            }
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new JdbcTableModify(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), JdbcTableModify.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.isFlattened());
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            throw new AssertionError();
        }
    }

    public static class JdbcTableModificationRule
    extends JdbcConverterRule {
        private JdbcTableModificationRule(JdbcConvention out) {
            super(LogicalTableModify.class, (RelTrait)Convention.NONE, out, "JdbcTableModificationRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalTableModify modify = (LogicalTableModify)rel;
            ModifiableTable modifiableTable = modify.getTable().unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                return null;
            }
            RelTraitSet traitSet = modify.getTraitSet().replace(this.out);
            return new JdbcTableModify(modify.getCluster(), traitSet, modify.getTable(), modify.getCatalogReader(), JdbcTableModificationRule.convert(modify.getInput(), traitSet), modify.getOperation(), modify.getUpdateColumnList(), modify.isFlattened());
        }
    }

    public static class JdbcMinus
    extends Minus
    implements JdbcRel {
        public JdbcMinus(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public JdbcMinus copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcMinus(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            return JdbcRules.setOpToSql(implementor, this.all ? SqlStdOperatorTable.EXCEPT_ALL : SqlStdOperatorTable.EXCEPT, this);
        }
    }

    private static class JdbcMinusRule
    extends JdbcConverterRule {
        private JdbcMinusRule(JdbcConvention out) {
            super(LogicalMinus.class, (RelTrait)Convention.NONE, out, "JdbcMinusRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalMinus minus = (LogicalMinus)rel;
            if (minus.all) {
                return null;
            }
            RelTraitSet traitSet = rel.getTraitSet().replace(this.out);
            return new JdbcMinus(rel.getCluster(), traitSet, JdbcMinusRule.convertList(minus.getInputs(), this.out), false);
        }
    }

    public static class JdbcIntersect
    extends Intersect
    implements JdbcRel {
        public JdbcIntersect(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public JdbcIntersect copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcIntersect(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            return JdbcRules.setOpToSql(implementor, this.all ? SqlStdOperatorTable.INTERSECT_ALL : SqlStdOperatorTable.INTERSECT, this);
        }
    }

    private static class JdbcIntersectRule
    extends JdbcConverterRule {
        private JdbcIntersectRule(JdbcConvention out) {
            super(LogicalIntersect.class, (RelTrait)Convention.NONE, out, "JdbcIntersectRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalIntersect intersect = (LogicalIntersect)rel;
            if (intersect.all) {
                return null;
            }
            RelTraitSet traitSet = intersect.getTraitSet().replace(this.out);
            return new JdbcIntersect(rel.getCluster(), traitSet, JdbcIntersectRule.convertList(intersect.getInputs(), this.out), false);
        }
    }

    public static class JdbcUnion
    extends Union
    implements JdbcRel {
        public JdbcUnion(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public JdbcUnion copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcUnion(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            SqlSetOperator operator = this.all ? SqlStdOperatorTable.UNION_ALL : SqlStdOperatorTable.UNION;
            return JdbcRules.setOpToSql(implementor, operator, this);
        }
    }

    private static class JdbcUnionRule
    extends JdbcConverterRule {
        private JdbcUnionRule(JdbcConvention out) {
            super(LogicalUnion.class, (RelTrait)Convention.NONE, out, "JdbcUnionRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalUnion union = (LogicalUnion)rel;
            RelTraitSet traitSet = union.getTraitSet().replace(this.out);
            return new JdbcUnion(rel.getCluster(), traitSet, JdbcUnionRule.convertList(union.getInputs(), this.out), union.all);
        }
    }

    public static class JdbcSort
    extends Sort
    implements JdbcRel {
        public JdbcSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation) {
            super(cluster, traitSet, input, collation);
            assert (this.getConvention() instanceof JdbcConvention);
            assert (this.getConvention() == input.getConvention());
        }

        @Override
        public JdbcSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
            if (offset != null || fetch != null) {
                throw new IllegalArgumentException("not supported: offset or fetch");
            }
            return new JdbcSort(this.getCluster(), traitSet, newInput, newCollation);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Result x = implementor.visitChild(0, this.getInput());
            JdbcImplementor.Builder builder = x.builder(this, JdbcImplementor.Clause.ORDER_BY);
            Expressions.FluentList orderByList = Expressions.list();
            for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
                if (fieldCollation.nullDirection != RelFieldCollation.NullDirection.UNSPECIFIED && implementor.dialect.getDatabaseProduct() == SqlDialect.DatabaseProduct.MYSQL) {
                    orderByList.add(ISNULL_FUNCTION.createCall(POS, builder.context.field(fieldCollation.getFieldIndex())));
                    fieldCollation = new RelFieldCollation(fieldCollation.getFieldIndex(), fieldCollation.getDirection());
                }
                orderByList.add(builder.context.toSql(fieldCollation));
            }
            builder.setOrderBy(new SqlNodeList((Collection<? extends SqlNode>)orderByList, POS));
            return builder.result();
        }
    }

    private static class JdbcSortRule
    extends JdbcConverterRule {
        private JdbcSortRule(JdbcConvention out) {
            super(Sort.class, (RelTrait)Convention.NONE, out, "JdbcSortRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            Sort sort = (Sort)rel;
            if (sort.offset != null || sort.fetch != null) {
                return null;
            }
            RelTraitSet traitSet = sort.getTraitSet().replace(this.out);
            return new JdbcSort(rel.getCluster(), traitSet, JdbcSortRule.convert(sort.getInput(), traitSet), sort.getCollation());
        }
    }

    public static class JdbcAggregate
    extends Aggregate
    implements JdbcRel {
        public JdbcAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
            super(cluster, traitSet, input, indicator, groupSet, groupSets, aggCalls);
            assert (this.getConvention() instanceof JdbcConvention);
            assert (this.groupSets.size() == 1) : "Grouping sets not supported";
            assert (!this.indicator);
            SqlDialect dialect = ((JdbcConvention)this.getConvention()).dialect;
            for (AggregateCall aggCall : aggCalls) {
                if (this.canImplement(aggCall.getAggregation(), dialect)) continue;
                throw new InvalidRelException("cannot implement aggregate function " + aggCall.getAggregation());
            }
        }

        private boolean canImplement(SqlAggFunction aggregation, SqlDialect sqlDialect) {
            switch (sqlDialect.getDatabaseProduct()) {
                case MYSQL: {
                    return MYSQL_AGG_FUNCS.contains((Object)aggregation);
                }
            }
            return AGG_FUNCS.contains((Object)aggregation);
        }

        @Override
        public JdbcAggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            try {
                return new JdbcAggregate(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Result x = implementor.visitChild(0, this.getInput());
            JdbcImplementor.Builder builder = x.builder(this, JdbcImplementor.Clause.GROUP_BY);
            Expressions.FluentList groupByList = Expressions.list();
            ArrayList selectList = new ArrayList();
            for (int group : this.groupSet) {
                SqlNode field = builder.context.field(group);
                JdbcRules.addSelect(selectList, field, this.getRowType());
                groupByList.add(field);
            }
            for (AggregateCall aggCall : this.aggCalls) {
                SqlNode aggCallSqlNode = builder.context.toSql(aggCall);
                if (aggCall.getAggregation() instanceof SqlSingleValueAggFunction) {
                    aggCallSqlNode = this.rewriteSingleValueExpr(aggCallSqlNode, implementor.dialect);
                }
                JdbcRules.addSelect(selectList, aggCallSqlNode, this.getRowType());
            }
            builder.setSelect(new SqlNodeList(selectList, POS));
            if (!groupByList.isEmpty() || this.aggCalls.isEmpty()) {
                builder.setGroupBy(new SqlNodeList((Collection<? extends SqlNode>)groupByList, POS));
            }
            return builder.result();
        }

        private SqlNode rewriteSingleValueExpr(SqlNode aggCall, SqlDialect sqlDialect) {
            SqlCall elseExpr;
            Object wrappedOperand;
            SqlCall caseOperand;
            Object operand = ((SqlBasicCall)aggCall).operand(0);
            SqlCall countCall = SqlStdOperatorTable.COUNT.createCall(POS, new SqlNode[]{operand});
            SqlLiteral nullLiteral = SqlLiteral.createNull(POS);
            switch (sqlDialect.getDatabaseProduct()) {
                case MYSQL: 
                case HSQLDB: {
                    SqlCall unionOperand;
                    caseOperand = countCall;
                    SqlNodeList selectList = new SqlNodeList(POS);
                    selectList.add(nullLiteral);
                    switch (sqlDialect.getDatabaseProduct()) {
                        case MYSQL: {
                            wrappedOperand = operand;
                            unionOperand = new SqlSelect(POS, SqlNodeList.EMPTY, selectList, null, null, null, null, SqlNodeList.EMPTY, null, null, null);
                            break;
                        }
                        default: {
                            wrappedOperand = SqlStdOperatorTable.MIN.createCall(POS, new SqlNode[]{operand});
                            unionOperand = SqlStdOperatorTable.VALUES.createCall(POS, SqlLiteral.createApproxNumeric("0", POS));
                        }
                    }
                    SqlCall unionAll = SqlStdOperatorTable.UNION_ALL.createCall(POS, unionOperand, unionOperand);
                    SqlNodeList subQuery = new SqlNodeList(POS);
                    subQuery.add(unionAll);
                    SqlNodeList selectList2 = new SqlNodeList(POS);
                    selectList2.add(nullLiteral);
                    elseExpr = SqlStdOperatorTable.SCALAR_QUERY.createCall(POS, subQuery);
                    break;
                }
                default: {
                    LOGGER.fine("SINGLE_VALUE rewrite not supported for " + (Object)((Object)sqlDialect.getDatabaseProduct()));
                    return aggCall;
                }
            }
            SqlNodeList whenList = new SqlNodeList(POS);
            whenList.add(SqlLiteral.createExactNumeric("0", POS));
            whenList.add(SqlLiteral.createExactNumeric("1", POS));
            SqlNodeList thenList = new SqlNodeList(POS);
            thenList.add(nullLiteral);
            thenList.add((SqlNode)wrappedOperand);
            SqlCase caseExpr = new SqlCase(POS, caseOperand, whenList, thenList, elseExpr);
            LOGGER.fine("SINGLE_VALUE rewritten into [" + caseExpr + "]");
            return caseExpr;
        }
    }

    private static class JdbcAggregateRule
    extends JdbcConverterRule {
        private JdbcAggregateRule(JdbcConvention out) {
            super(LogicalAggregate.class, (RelTrait)Convention.NONE, out, "JdbcAggregateRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            if (agg.getGroupSets().size() != 1) {
                return null;
            }
            RelTraitSet traitSet = agg.getTraitSet().replace(this.out);
            try {
                return new JdbcAggregate(rel.getCluster(), traitSet, JdbcAggregateRule.convert(agg.getInput(), this.out), agg.indicator, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                LOGGER.fine(e.toString());
                return null;
            }
        }
    }

    public static class JdbcFilter
    extends Filter
    implements JdbcRel {
        public JdbcFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode condition) {
            super(cluster, traitSet, input, condition);
            assert (this.getConvention() instanceof JdbcConvention);
        }

        @Override
        public JdbcFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
            return new JdbcFilter(this.getCluster(), traitSet, input, condition);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Result x = implementor.visitChild(0, this.getInput());
            JdbcImplementor.Builder builder = x.builder(this, JdbcImplementor.Clause.WHERE);
            builder.setWhere(builder.context.toSql(null, this.condition));
            return builder.result();
        }
    }

    private static class JdbcFilterRule
    extends JdbcConverterRule {
        private JdbcFilterRule(JdbcConvention out) {
            super(LogicalFilter.class, (RelTrait)Convention.NONE, out, "JdbcFilterRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            return new JdbcFilter(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcFilterRule.convert(filter.getInput(), filter.getInput().getTraitSet().replace(this.out)), filter.getCondition());
        }
    }

    public static class JdbcProject
    extends Project
    implements JdbcRel {
        public JdbcProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
            super(cluster, traitSet, input, projects, rowType);
            assert (this.getConvention() instanceof JdbcConvention);
        }

        @Deprecated
        public JdbcProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType, int flags) {
            this(cluster, traitSet, input, projects, rowType);
            Util.discard(flags);
        }

        @Override
        public JdbcProject copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
            return new JdbcProject(this.getCluster(), traitSet, input, projects, rowType);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.8);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Result x = implementor.visitChild(0, this.getInput());
            if (JdbcRules.isStar((List)this.exps, this.getInput().getRowType())) {
                return x;
            }
            JdbcImplementor.Builder builder = x.builder(this, JdbcImplementor.Clause.SELECT);
            ArrayList selectList = new ArrayList();
            for (RexNode ref : this.exps) {
                SqlNode sqlExpr = builder.context.toSql(null, ref);
                JdbcRules.addSelect(selectList, sqlExpr, this.getRowType());
            }
            builder.setSelect(new SqlNodeList(selectList, POS));
            return builder.result();
        }
    }

    private static class JdbcProjectRule
    extends JdbcConverterRule {
        private JdbcProjectRule(JdbcConvention out) {
            super(LogicalProject.class, (RelTrait)Convention.NONE, out, "JdbcProjectRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            return new JdbcProject(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcProjectRule.convert(project.getInput(), project.getInput().getTraitSet().replace(this.out)), project.getProjects(), project.getRowType());
        }
    }

    public static class JdbcCalc
    extends SingleRel
    implements JdbcRel {
        private final RexProgram program;

        public JdbcCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program) {
            super(cluster, traitSet, input);
            assert (this.getConvention() instanceof JdbcConvention);
            this.program = program;
            this.rowType = program.getOutputRowType();
        }

        @Deprecated
        public JdbcCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program, int flags) {
            this(cluster, traitSet, input, program);
            Util.discard(flags);
        }

        @Override
        public RelWriter explainTerms(RelWriter pw) {
            return this.program.explainCalc(super.explainTerms(pw));
        }

        @Override
        public double estimateRowCount(RelMetadataQuery mq) {
            return RelMdUtil.estimateFilteredRows(this.getInput(), this.program, mq);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            double dRows = mq.getRowCount(this);
            double dCpu = mq.getRowCount(this.getInput()) * (double)this.program.getExprCount();
            double dIo = 0.0;
            return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new JdbcCalc(this.getCluster(), traitSet, JdbcCalc.sole(inputs), this.program);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Builder builder;
            JdbcImplementor.Result x = implementor.visitChild(0, this.getInput());
            JdbcImplementor.Builder builder2 = builder = this.program.getCondition() != null ? x.builder(this, JdbcImplementor.Clause.FROM, JdbcImplementor.Clause.WHERE) : x.builder(this, JdbcImplementor.Clause.FROM);
            if (!JdbcRules.isStar(this.program)) {
                ArrayList selectList = new ArrayList();
                for (RexLocalRef ref : this.program.getProjectList()) {
                    SqlNode sqlExpr = builder.context.toSql(this.program, ref);
                    JdbcRules.addSelect(selectList, sqlExpr, this.getRowType());
                }
                builder.setSelect(new SqlNodeList(selectList, POS));
            }
            if (this.program.getCondition() != null) {
                builder.setWhere(builder.context.toSql(this.program, this.program.getCondition()));
            }
            return builder.result();
        }
    }

    private static class JdbcCalcRule
    extends JdbcConverterRule {
        private JdbcCalcRule(JdbcConvention out) {
            super(LogicalCalc.class, (RelTrait)Convention.NONE, out, "JdbcCalcRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalCalc calc = (LogicalCalc)rel;
            if (RexMultisetUtil.containsMultiset(calc.getProgram())) {
                return null;
            }
            return new JdbcCalc(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcCalcRule.convert(calc.getInput(), calc.getTraitSet().replace(this.out)), calc.getProgram());
        }
    }

    public static class JdbcJoin
    extends Join
    implements JdbcRel {
        protected JdbcJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
            super(cluster, traitSet, left, right, condition, joinType, variablesStopped);
        }

        @Override
        public JdbcJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
            try {
                return new JdbcJoin(this.getCluster(), traitSet, left, right, condition, joinType, (Set<String>)this.variablesStopped);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            double rowCount = mq.getRowCount(this);
            return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
        }

        @Override
        public double estimateRowCount(RelMetadataQuery mq) {
            double leftRowCount = this.left.estimateRowCount(mq);
            double rightRowCount = this.right.estimateRowCount(mq);
            return Math.max(leftRowCount, rightRowCount);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Result leftResult = implementor.visitChild(0, this.left);
            JdbcImplementor.Result rightResult = implementor.visitChild(1, this.right);
            JdbcImplementor.Context leftContext = leftResult.qualifiedContext();
            JdbcImplementor.Context rightContext = rightResult.qualifiedContext();
            SqlNode sqlCondition = this.convertConditionToSqlNode(this.condition, leftContext, rightContext, this.left.getRowType().getFieldCount());
            SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean(false, POS), JdbcJoin.joinType(this.joinType).symbol(POS), rightResult.asFrom(), JoinConditionType.ON.symbol(POS), sqlCondition);
            return implementor.result((SqlNode)join, leftResult, rightResult);
        }

        private SqlNode convertConditionToSqlNode(RexNode node, JdbcImplementor.Context leftContext, JdbcImplementor.Context rightContext, int leftFieldCount) {
            if (!(node instanceof RexCall)) {
                throw new AssertionError(node);
            }
            switch (node.getKind()) {
                case AND: 
                case OR: {
                    List<RexNode> operands = ((RexCall)node).getOperands();
                    SqlOperator op = ((RexCall)node).getOperator();
                    SqlNode sqlCondition = null;
                    for (RexNode operand : operands) {
                        SqlNode x = this.convertConditionToSqlNode(operand, leftContext, rightContext, leftFieldCount);
                        if (sqlCondition == null) {
                            sqlCondition = x;
                            continue;
                        }
                        sqlCondition = op.createCall(POS, sqlCondition, x);
                    }
                    return sqlCondition;
                }
                case EQUALS: 
                case IS_NOT_DISTINCT_FROM: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    List<RexNode> operands = ((RexCall)node).getOperands();
                    SqlOperator op = ((RexCall)node).getOperator();
                    if (!(operands.get(0) instanceof RexInputRef) || !(operands.get(1) instanceof RexInputRef)) break;
                    RexInputRef op0 = (RexInputRef)operands.get(0);
                    RexInputRef op1 = (RexInputRef)operands.get(1);
                    if (op0.getIndex() < leftFieldCount && op1.getIndex() >= leftFieldCount) {
                        return op.createCall(POS, leftContext.field(op0.getIndex()), rightContext.field(op1.getIndex() - leftFieldCount));
                    }
                    if (op1.getIndex() >= leftFieldCount || op0.getIndex() < leftFieldCount) break;
                    return JdbcJoin.reverseOperatorDirection(op).createCall(POS, leftContext.field(op1.getIndex()), rightContext.field(op0.getIndex() - leftFieldCount));
                }
            }
            throw new AssertionError(node);
        }

        private static SqlOperator reverseOperatorDirection(SqlOperator op) {
            switch (op.kind) {
                case GREATER_THAN: {
                    return SqlStdOperatorTable.LESS_THAN;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
                }
                case LESS_THAN: {
                    return SqlStdOperatorTable.GREATER_THAN;
                }
                case LESS_THAN_OR_EQUAL: {
                    return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
                }
                case EQUALS: 
                case IS_NOT_DISTINCT_FROM: 
                case NOT_EQUALS: {
                    return op;
                }
            }
            throw new AssertionError(op);
        }

        private static JoinType joinType(JoinRelType joinType) {
            switch (joinType) {
                case LEFT: {
                    return JoinType.LEFT;
                }
                case RIGHT: {
                    return JoinType.RIGHT;
                }
                case INNER: {
                    return JoinType.INNER;
                }
                case FULL: {
                    return JoinType.FULL;
                }
            }
            throw new AssertionError((Object)joinType);
        }
    }

    private static class JdbcJoinRule
    extends JdbcConverterRule {
        private JdbcJoinRule(JdbcConvention out) {
            super(LogicalJoin.class, (RelTrait)Convention.NONE, out, "JdbcJoinRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalJoin join = (LogicalJoin)rel;
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : join.getInputs()) {
                if (input.getConvention() != this.getOutTrait()) {
                    input = JdbcJoinRule.convert(input, input.getTraitSet().replace(this.out));
                }
                newInputs.add(input);
            }
            if (!this.canJoinOnCondition(join.getCondition())) {
                return null;
            }
            try {
                return new JdbcJoin(join.getCluster(), join.getTraitSet().replace(this.out), (RelNode)newInputs.get(0), (RelNode)newInputs.get(1), join.getCondition(), join.getJoinType(), join.getVariablesStopped());
            }
            catch (InvalidRelException e) {
                LOGGER.fine(e.toString());
                return null;
            }
        }

        private boolean canJoinOnCondition(RexNode node) {
            switch (node.getKind()) {
                case AND: 
                case OR: {
                    List<RexNode> operands = ((RexCall)node).getOperands();
                    for (RexNode operand : operands) {
                        if (this.canJoinOnCondition(operand)) continue;
                        return false;
                    }
                    return true;
                }
                case EQUALS: 
                case IS_NOT_DISTINCT_FROM: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    List<RexNode> operands = ((RexCall)node).getOperands();
                    if (!(operands.get(0) instanceof RexInputRef) || !(operands.get(1) instanceof RexInputRef)) break;
                    return true;
                }
            }
            return false;
        }
    }

    static abstract class JdbcConverterRule
    extends ConverterRule {
        protected final JdbcConvention out;

        public JdbcConverterRule(Class<? extends RelNode> clazz, RelTrait in, JdbcConvention out, String description) {
            super(clazz, in, out, description);
            this.out = out;
        }
    }
}

