/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.sqs.model.BatchResultErrorEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResultEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendMessageBatchResult
implements Serializable {
    private ListWithAutoConstructFlag<SendMessageBatchResultEntry> successful;
    private ListWithAutoConstructFlag<BatchResultErrorEntry> failed;

    public List<SendMessageBatchResultEntry> getSuccessful() {
        if (this.successful == null) {
            this.successful = new ListWithAutoConstructFlag();
            this.successful.setAutoConstruct(true);
        }
        return this.successful;
    }

    public void setSuccessful(Collection<SendMessageBatchResultEntry> successful) {
        if (successful == null) {
            this.successful = null;
            return;
        }
        ListWithAutoConstructFlag successfulCopy = new ListWithAutoConstructFlag(successful.size());
        successfulCopy.addAll(successful);
        this.successful = successfulCopy;
    }

    public SendMessageBatchResult withSuccessful(SendMessageBatchResultEntry ... successful) {
        if (this.getSuccessful() == null) {
            this.setSuccessful(new ArrayList<SendMessageBatchResultEntry>(successful.length));
        }
        for (SendMessageBatchResultEntry value : successful) {
            this.getSuccessful().add(value);
        }
        return this;
    }

    public SendMessageBatchResult withSuccessful(Collection<SendMessageBatchResultEntry> successful) {
        if (successful == null) {
            this.successful = null;
        } else {
            ListWithAutoConstructFlag successfulCopy = new ListWithAutoConstructFlag(successful.size());
            successfulCopy.addAll(successful);
            this.successful = successfulCopy;
        }
        return this;
    }

    public List<BatchResultErrorEntry> getFailed() {
        if (this.failed == null) {
            this.failed = new ListWithAutoConstructFlag();
            this.failed.setAutoConstruct(true);
        }
        return this.failed;
    }

    public void setFailed(Collection<BatchResultErrorEntry> failed) {
        if (failed == null) {
            this.failed = null;
            return;
        }
        ListWithAutoConstructFlag failedCopy = new ListWithAutoConstructFlag(failed.size());
        failedCopy.addAll(failed);
        this.failed = failedCopy;
    }

    public SendMessageBatchResult withFailed(BatchResultErrorEntry ... failed) {
        if (this.getFailed() == null) {
            this.setFailed(new ArrayList<BatchResultErrorEntry>(failed.length));
        }
        for (BatchResultErrorEntry value : failed) {
            this.getFailed().add(value);
        }
        return this;
    }

    public SendMessageBatchResult withFailed(Collection<BatchResultErrorEntry> failed) {
        if (failed == null) {
            this.failed = null;
        } else {
            ListWithAutoConstructFlag failedCopy = new ListWithAutoConstructFlag(failed.size());
            failedCopy.addAll(failed);
            this.failed = failedCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSuccessful() != null) {
            sb.append("Successful: " + this.getSuccessful() + ",");
        }
        if (this.getFailed() != null) {
            sb.append("Failed: " + this.getFailed());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSuccessful() == null ? 0 : ((Object)this.getSuccessful()).hashCode());
        hashCode = 31 * hashCode + (this.getFailed() == null ? 0 : ((Object)this.getFailed()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchResult)) {
            return false;
        }
        SendMessageBatchResult other = (SendMessageBatchResult)obj;
        if (other.getSuccessful() == null ^ this.getSuccessful() == null) {
            return false;
        }
        if (other.getSuccessful() != null && !((Object)other.getSuccessful()).equals(this.getSuccessful())) {
            return false;
        }
        if (other.getFailed() == null ^ this.getFailed() == null) {
            return false;
        }
        return other.getFailed() == null || ((Object)other.getFailed()).equals(this.getFailed());
    }
}

