/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.services.s3.internal.AbstractS3ResponseHandler;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.transform.Unmarshaller;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3XmlResponseHandler<T>
extends AbstractS3ResponseHandler<T> {
    private Unmarshaller<T, InputStream> responseUnmarshaller;
    private static final Log log = LogFactory.getLog((String)"com.amazonaws.request");
    private Map<String, String> responseHeaders;

    public S3XmlResponseHandler(Unmarshaller<T, InputStream> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
    }

    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        AmazonWebServiceResponse<Object> awsResponse = this.parseResponseMetadata(response);
        this.responseHeaders = response.getHeaders();
        if (this.responseUnmarshaller != null) {
            log.trace((Object)"Beginning to parse service response XML");
            Object result = null;
            try {
                result = this.responseUnmarshaller.unmarshall(response.getContent());
            }
            catch (AmazonClientException ace) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received a successfull response. But failed to parse the payload.");
                }
                throw this.newAmazonS3Exception(ace, response);
            }
            log.trace((Object)"Done parsing service response XML");
            awsResponse.setResult(result);
        }
        return awsResponse;
    }

    private AmazonS3Exception newAmazonS3Exception(AmazonClientException ace, HttpResponse response) {
        AmazonS3Exception s3Exception = new AmazonS3Exception("Received a successfull response. But failed to parse the payload.", ace);
        s3Exception.setExtendedRequestId(this.getHeaderValue("x-amz-id-2"));
        s3Exception.setRequestId(this.getHeaderValue("x-amz-request-id"));
        s3Exception.setStatusCode(response.getStatusCode());
        s3Exception.setErrorCode("Invalid Response");
        s3Exception.setServiceName(response.getRequest().getServiceName());
        return s3Exception;
    }

    private String getHeaderValue(String header) {
        return this.responseHeaders.get(header);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

