/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDBSecurityGroupRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String dBSecurityGroupName;
    private String dBSecurityGroupDescription;
    private ListWithAutoConstructFlag<Tag> tags;

    public CreateDBSecurityGroupRequest() {
    }

    public CreateDBSecurityGroupRequest(String dBSecurityGroupName, String dBSecurityGroupDescription) {
        this.setDBSecurityGroupName(dBSecurityGroupName);
        this.setDBSecurityGroupDescription(dBSecurityGroupDescription);
    }

    public String getDBSecurityGroupName() {
        return this.dBSecurityGroupName;
    }

    public void setDBSecurityGroupName(String dBSecurityGroupName) {
        this.dBSecurityGroupName = dBSecurityGroupName;
    }

    public CreateDBSecurityGroupRequest withDBSecurityGroupName(String dBSecurityGroupName) {
        this.dBSecurityGroupName = dBSecurityGroupName;
        return this;
    }

    public String getDBSecurityGroupDescription() {
        return this.dBSecurityGroupDescription;
    }

    public void setDBSecurityGroupDescription(String dBSecurityGroupDescription) {
        this.dBSecurityGroupDescription = dBSecurityGroupDescription;
    }

    public CreateDBSecurityGroupRequest withDBSecurityGroupDescription(String dBSecurityGroupDescription) {
        this.dBSecurityGroupDescription = dBSecurityGroupDescription;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CreateDBSecurityGroupRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CreateDBSecurityGroupRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBSecurityGroupName() != null) {
            sb.append("DBSecurityGroupName: " + this.getDBSecurityGroupName() + ",");
        }
        if (this.getDBSecurityGroupDescription() != null) {
            sb.append("DBSecurityGroupDescription: " + this.getDBSecurityGroupDescription() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBSecurityGroupName() == null ? 0 : this.getDBSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDBSecurityGroupDescription() == null ? 0 : this.getDBSecurityGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDBSecurityGroupRequest)) {
            return false;
        }
        CreateDBSecurityGroupRequest other = (CreateDBSecurityGroupRequest)obj;
        if (other.getDBSecurityGroupName() == null ^ this.getDBSecurityGroupName() == null) {
            return false;
        }
        if (other.getDBSecurityGroupName() != null && !other.getDBSecurityGroupName().equals(this.getDBSecurityGroupName())) {
            return false;
        }
        if (other.getDBSecurityGroupDescription() == null ^ this.getDBSecurityGroupDescription() == null) {
            return false;
        }
        if (other.getDBSecurityGroupDescription() != null && !other.getDBSecurityGroupDescription().equals(this.getDBSecurityGroupDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || ((Object)other.getTags()).equals(this.getTags());
    }
}

