/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.DescribeCommandsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeCommandsRequestMarshaller
implements Marshaller<Request<DescribeCommandsRequest>, DescribeCommandsRequest> {
    @Override
    public Request<DescribeCommandsRequest> marshall(DescribeCommandsRequest describeCommandsRequest) {
        if (describeCommandsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeCommandsRequest> request = new DefaultRequest<DescribeCommandsRequest>(describeCommandsRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.DescribeCommands";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag commandIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeCommandsRequest.getDeploymentId() != null) {
                jsonWriter.key("DeploymentId").value(describeCommandsRequest.getDeploymentId());
            }
            if (describeCommandsRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value(describeCommandsRequest.getInstanceId());
            }
            if (!((commandIdsList = (ListWithAutoConstructFlag)describeCommandsRequest.getCommandIds()) == null || commandIdsList.isAutoConstruct() && commandIdsList.isEmpty())) {
                jsonWriter.key("CommandIds");
                jsonWriter.array();
                for (String commandIdsListValue : commandIdsList) {
                    if (commandIdsListValue == null) continue;
                    jsonWriter.value(commandIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

