/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListStreamsResult
implements Serializable {
    private ListWithAutoConstructFlag<String> streamNames;
    private Boolean hasMoreStreams;

    public List<String> getStreamNames() {
        if (this.streamNames == null) {
            this.streamNames = new ListWithAutoConstructFlag();
            this.streamNames.setAutoConstruct(true);
        }
        return this.streamNames;
    }

    public void setStreamNames(Collection<String> streamNames) {
        if (streamNames == null) {
            this.streamNames = null;
            return;
        }
        ListWithAutoConstructFlag streamNamesCopy = new ListWithAutoConstructFlag(streamNames.size());
        streamNamesCopy.addAll(streamNames);
        this.streamNames = streamNamesCopy;
    }

    public ListStreamsResult withStreamNames(String ... streamNames) {
        if (this.getStreamNames() == null) {
            this.setStreamNames(new ArrayList<String>(streamNames.length));
        }
        for (String value : streamNames) {
            this.getStreamNames().add(value);
        }
        return this;
    }

    public ListStreamsResult withStreamNames(Collection<String> streamNames) {
        if (streamNames == null) {
            this.streamNames = null;
        } else {
            ListWithAutoConstructFlag streamNamesCopy = new ListWithAutoConstructFlag(streamNames.size());
            streamNamesCopy.addAll(streamNames);
            this.streamNames = streamNamesCopy;
        }
        return this;
    }

    public Boolean isHasMoreStreams() {
        return this.hasMoreStreams;
    }

    public void setHasMoreStreams(Boolean hasMoreStreams) {
        this.hasMoreStreams = hasMoreStreams;
    }

    public ListStreamsResult withHasMoreStreams(Boolean hasMoreStreams) {
        this.hasMoreStreams = hasMoreStreams;
        return this;
    }

    public Boolean getHasMoreStreams() {
        return this.hasMoreStreams;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamNames() != null) {
            sb.append("StreamNames: " + this.getStreamNames() + ",");
        }
        if (this.isHasMoreStreams() != null) {
            sb.append("HasMoreStreams: " + this.isHasMoreStreams());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamNames() == null ? 0 : ((Object)this.getStreamNames()).hashCode());
        hashCode = 31 * hashCode + (this.isHasMoreStreams() == null ? 0 : this.isHasMoreStreams().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResult)) {
            return false;
        }
        ListStreamsResult other = (ListStreamsResult)obj;
        if (other.getStreamNames() == null ^ this.getStreamNames() == null) {
            return false;
        }
        if (other.getStreamNames() != null && !((Object)other.getStreamNames()).equals(this.getStreamNames())) {
            return false;
        }
        if (other.isHasMoreStreams() == null ^ this.isHasMoreStreams() == null) {
            return false;
        }
        return other.isHasMoreStreams() == null || other.isHasMoreStreams().equals(this.isHasMoreStreams());
    }
}

