/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.StepSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListStepsResult
implements Serializable {
    private ListWithAutoConstructFlag<StepSummary> steps;
    private String marker;

    public List<StepSummary> getSteps() {
        if (this.steps == null) {
            this.steps = new ListWithAutoConstructFlag();
            this.steps.setAutoConstruct(true);
        }
        return this.steps;
    }

    public void setSteps(Collection<StepSummary> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        ListWithAutoConstructFlag stepsCopy = new ListWithAutoConstructFlag(steps.size());
        stepsCopy.addAll(steps);
        this.steps = stepsCopy;
    }

    public ListStepsResult withSteps(StepSummary ... steps) {
        if (this.getSteps() == null) {
            this.setSteps(new ArrayList<StepSummary>(steps.length));
        }
        for (StepSummary value : steps) {
            this.getSteps().add(value);
        }
        return this;
    }

    public ListStepsResult withSteps(Collection<StepSummary> steps) {
        if (steps == null) {
            this.steps = null;
        } else {
            ListWithAutoConstructFlag stepsCopy = new ListWithAutoConstructFlag(steps.size());
            stepsCopy.addAll(steps);
            this.steps = stepsCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListStepsResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSteps() != null) {
            sb.append("Steps: " + this.getSteps() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : ((Object)this.getSteps()).hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepsResult)) {
            return false;
        }
        ListStepsResult other = (ListStepsResult)obj;
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        if (other.getSteps() != null && !((Object)other.getSteps()).equals(this.getSteps())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

